/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.app;

import android.app.UiAutomation;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Choreographer;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.core.app.DeviceCapture;
import androidx.test.core.app.ListFuture;
import androidx.test.core.internal.os.HandlerExecutor;
import androidx.test.core.view.ViewCapture;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.platform.graphics.HardwareRendererCompat;
import androidx.test.platform.view.inspector.WindowInspectorCompat;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0003\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"forceRedrawGlobalWindowViews", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "Ljava/lang/Void;", "mainExecutor", "Ljava/util/concurrent/Executor;", "takeScreenshot", "Landroid/graphics/Bitmap;", "third_party.android.androidx_test.core.java.androidx.test.core_core_internal"})
@JvmName(name="DeviceCapture")
public final class DeviceCapture {
    @ExperimentalTestApi
    @RequiresApi(value=18)
    @NotNull
    public static final Bitmap takeScreenshot() throws RuntimeException {
        Checks.checkNotMainThread();
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableFuture, (String)"create()");
        ResolvableFuture bitmapFuture = resolvableFuture;
        HandlerExecutor mainExecutor = new HandlerExecutor(new Handler(Looper.getMainLooper()));
        UiAutomation uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        if (!HardwareRendererCompat.isDrawingEnabled()) {
            HardwareRendererCompat.setDrawingEnabled((boolean)true);
            bitmapFuture.addListener((Runnable)takeScreenshot.1.INSTANCE, (Executor)mainExecutor);
        }
        try {
            DeviceCapture.forceRedrawGlobalWindowViews(mainExecutor).get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Log.w((String)"takeScreenshot", (String)"force redraw failed. Proceeding with screenshot", (Throwable)e);
        }
        mainExecutor.execute(new Runnable(uiAutomation, (ResolvableFuture<Bitmap>)bitmapFuture){
            final /* synthetic */ UiAutomation $uiAutomation;
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            {
                this.$uiAutomation = $uiAutomation;
                this.$bitmapFuture = $bitmapFuture;
            }

            public final void run() {
                Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(this.$uiAutomation, this.$bitmapFuture){
                    final /* synthetic */ UiAutomation $uiAutomation;
                    final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
                    {
                        this.$uiAutomation = $uiAutomation;
                        this.$bitmapFuture = $bitmapFuture;
                    }

                    public final void doFrame(long it) {
                        Bitmap bitmap = this.$uiAutomation.takeScreenshot();
                        if (bitmap == null) {
                            this.$bitmapFuture.setException((Throwable)new RuntimeException("uiAutomation.takeScreenshot returned null"));
                        } else {
                            this.$bitmapFuture.set((Object)bitmap);
                        }
                    }
                });
            }
        });
        Object object = bitmapFuture.get(5L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bitmapFuture.get(5, TimeUnit.SECONDS)");
        return (Bitmap)object;
    }

    @RequiresApi(value=18)
    private static final ListenableFuture<List<Void>> forceRedrawGlobalWindowViews(Executor mainExecutor) {
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableFuture, (String)"create()");
        ResolvableFuture future = resolvableFuture;
        mainExecutor.execute(new Runnable((ResolvableFuture<List<Void>>)future, mainExecutor){
            final /* synthetic */ ResolvableFuture<List<Void>> $future;
            final /* synthetic */ Executor $mainExecutor;
            {
                this.$future = $future;
                this.$mainExecutor = $mainExecutor;
            }

            public final void run() {
                List views = WindowInspectorCompat.getGlobalWindowViews();
                boolean bl = false;
                List viewFutures = new ArrayList<E>();
                for (View view : views) {
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                    viewFutures.add(ViewCapture.forceRedraw(view));
                }
                Log.d((String)"takeScreenshot", (String)("Found " + views.size() + " global views to redraw"));
                this.$future.setFuture((ListenableFuture)new ListFuture<V>(viewFutures, true, this.$mainExecutor));
            }
        });
        return (ListenableFuture)future;
    }
}

