/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.PixelCopy;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.core.internal.os.HandlerExecutor;
import androidx.test.core.view.ViewCapture;
import androidx.test.core.view.WindowCapture;
import androidx.test.platform.graphics.HardwareRendererCompat;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0007\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003H\u0007\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a\"\u0010\n\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0000\u001a*\u0010\f\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a\"\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0003H\u0002\u00a8\u0006\u0013"}, d2={"captureToBitmap", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroid/graphics/Bitmap;", "Landroid/view/View;", "forceRedraw", "Ljava/lang/Void;", "generateBitmap", "", "bitmapFuture", "Landroidx/concurrent/futures/ResolvableFuture;", "generateBitmapFromDraw", "destBitmap", "generateBitmapFromPixelCopy", "window", "Landroid/view/Window;", "generateBitmapFromSurfaceViewPixelCopy", "Landroid/view/SurfaceView;", "getActivity", "Landroid/app/Activity;", "third_party.android.androidx_test.core.java.androidx.test.core_core_internal"})
@JvmName(name="ViewCapture")
public final class ViewCapture {
    @ExperimentalTestApi
    @RequiresApi(value=16)
    @NotNull
    public static final ListenableFuture<Bitmap> captureToBitmap(@NotNull View $this$captureToBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableFuture, (String)"create()");
        ResolvableFuture bitmapFuture = resolvableFuture;
        HandlerExecutor mainExecutor = new HandlerExecutor(new Handler(Looper.getMainLooper()));
        if (!HardwareRendererCompat.isDrawingEnabled()) {
            HardwareRendererCompat.setDrawingEnabled((boolean)true);
            bitmapFuture.addListener((Runnable)captureToBitmap.1.INSTANCE, (Executor)mainExecutor);
        }
        mainExecutor.execute(new Runnable($this$captureToBitmap, mainExecutor, (ResolvableFuture<Bitmap>)bitmapFuture){
            final /* synthetic */ View $this_captureToBitmap;
            final /* synthetic */ HandlerExecutor $mainExecutor;
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            {
                this.$this_captureToBitmap = $receiver;
                this.$mainExecutor = $mainExecutor;
                this.$bitmapFuture = $bitmapFuture;
            }

            public final void run() {
                ListenableFuture<Void> forceRedrawFuture = ViewCapture.forceRedraw(this.$this_captureToBitmap);
                forceRedrawFuture.addListener(new Runnable(this.$this_captureToBitmap, this.$bitmapFuture){
                    final /* synthetic */ View $this_captureToBitmap;
                    final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
                    {
                        this.$this_captureToBitmap = $receiver;
                        this.$bitmapFuture = $bitmapFuture;
                    }

                    public final void run() {
                        ViewCapture.access$generateBitmap(this.$this_captureToBitmap, this.$bitmapFuture);
                    }
                }, (Executor)this.$mainExecutor);
            }
        });
        return (ListenableFuture)bitmapFuture;
    }

    @RequiresApi(value=16)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ExperimentalTestApi
    @NotNull
    public static final ListenableFuture<Void> forceRedraw(@NotNull View $this$forceRedraw) {
        Intrinsics.checkNotNullParameter((Object)$this$forceRedraw, (String)"<this>");
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableFuture, (String)"create()");
        ResolvableFuture future = resolvableFuture;
        if (Build.VERSION.SDK_INT >= 29 && $this$forceRedraw.isHardwareAccelerated()) {
            $this$forceRedraw.getViewTreeObserver().registerFrameCommitCallback(new Runnable((ResolvableFuture<Void>)future){
                final /* synthetic */ ResolvableFuture<Void> $future;
                {
                    this.$future = $future;
                }

                public final void run() {
                    this.$future.set(null);
                }
            });
        } else {
            $this$forceRedraw.getViewTreeObserver().addOnDrawListener(new ViewTreeObserver.OnDrawListener((ResolvableFuture<Void>)future, $this$forceRedraw){
                private boolean handled;
                final /* synthetic */ ResolvableFuture<Void> $future;
                final /* synthetic */ View $this_forceRedraw;
                {
                    this.$future = $future;
                    this.$this_forceRedraw = $receiver;
                }

                public final boolean getHandled() {
                    return this.handled;
                }

                public final void setHandled(boolean bl) {
                    this.handled = bl;
                }

                public void onDraw() {
                    if (!this.handled) {
                        this.handled = true;
                        this.$future.set(null);
                        new Handler(Looper.getMainLooper()).post(new Runnable(this.$this_forceRedraw, this){
                            final /* synthetic */ View $this_forceRedraw;
                            final /* synthetic */ forceRedraw.2 this$0;
                            {
                                this.$this_forceRedraw = $receiver;
                                this.this$0 = $receiver2;
                            }

                            public final void run() {
                                this.$this_forceRedraw.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.this$0);
                            }
                        });
                    }
                }
            });
        }
        $this$forceRedraw.invalidate();
        return (ListenableFuture)future;
    }

    private static final void generateBitmap(View $this$generateBitmap, ResolvableFuture<Bitmap> bitmapFuture) {
        if (bitmapFuture.isCancelled()) {
            return;
        }
        Bitmap destBitmap = Bitmap.createBitmap((int)$this$generateBitmap.getWidth(), (int)$this$generateBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (Build.VERSION.SDK_INT < 26) {
            Intrinsics.checkNotNullExpressionValue((Object)destBitmap, (String)"destBitmap");
            ViewCapture.generateBitmapFromDraw($this$generateBitmap, destBitmap, bitmapFuture);
        } else if ($this$generateBitmap instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)$this$generateBitmap;
            Intrinsics.checkNotNullExpressionValue((Object)destBitmap, (String)"destBitmap");
            ViewCapture.generateBitmapFromSurfaceViewPixelCopy(surfaceView, destBitmap, bitmapFuture);
        } else {
            Window window;
            Activity activity = ViewCapture.getActivity($this$generateBitmap);
            Window window2 = window = activity == null ? null : activity.getWindow();
            if (window != null) {
                Intrinsics.checkNotNullExpressionValue((Object)destBitmap, (String)"destBitmap");
                ViewCapture.generateBitmapFromPixelCopy($this$generateBitmap, window, destBitmap, bitmapFuture);
            } else {
                Log.i((String)"View.captureToImage", (String)"Could not find window for view. Falling back to View#draw instead of PixelCopy");
                Intrinsics.checkNotNullExpressionValue((Object)destBitmap, (String)"destBitmap");
                ViewCapture.generateBitmapFromDraw($this$generateBitmap, destBitmap, bitmapFuture);
            }
        }
    }

    private static final void generateBitmapFromSurfaceViewPixelCopy(SurfaceView $this$generateBitmapFromSurfaceViewPixelCopy, Bitmap destBitmap, ResolvableFuture<Bitmap> bitmapFuture) {
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(bitmapFuture, destBitmap){
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            final /* synthetic */ Bitmap $destBitmap;
            {
                this.$bitmapFuture = $bitmapFuture;
                this.$destBitmap = $destBitmap;
            }

            public final void onPixelCopyFinished(int result) {
                if (result == 0) {
                    this.$bitmapFuture.set((Object)this.$destBitmap);
                } else {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "PixelCopy failed: %d";
                    Object[] objectArray = new Object[]{result};
                    boolean bl = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    this.$bitmapFuture.setException((Throwable)new RuntimeException(string2));
                }
            }
        };
        PixelCopy.request((SurfaceView)$this$generateBitmapFromSurfaceViewPixelCopy, null, (Bitmap)destBitmap, (PixelCopy.OnPixelCopyFinishedListener)onCopyFinished2, (Handler)$this$generateBitmapFromSurfaceViewPixelCopy.getHandler());
    }

    public static final void generateBitmapFromDraw(@NotNull View $this$generateBitmapFromDraw, @NotNull Bitmap destBitmap, @NotNull ResolvableFuture<Bitmap> bitmapFuture) {
        Intrinsics.checkNotNullParameter((Object)$this$generateBitmapFromDraw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destBitmap, (String)"destBitmap");
        Intrinsics.checkNotNullParameter(bitmapFuture, (String)"bitmapFuture");
        destBitmap.setDensity($this$generateBitmapFromDraw.getResources().getDisplayMetrics().densityDpi);
        $this$generateBitmapFromDraw.computeScroll();
        Canvas canvas = new Canvas(destBitmap);
        canvas.translate((float)(-$this$generateBitmapFromDraw.getScrollX()), (float)(-$this$generateBitmapFromDraw.getScrollY()));
        $this$generateBitmapFromDraw.draw(canvas);
        bitmapFuture.set((Object)destBitmap);
    }

    private static final Activity getActivity(View $this$getActivity) {
        Context context = $this$getActivity.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return ViewCapture.getActivity$getActivity(context);
    }

    private static final void generateBitmapFromPixelCopy(View $this$generateBitmapFromPixelCopy, Window window, Bitmap destBitmap, ResolvableFuture<Bitmap> bitmapFuture) {
        int[] nArray = new int[]{0, 0};
        int[] locationInWindow = nArray;
        $this$generateBitmapFromPixelCopy.getLocationInWindow(locationInWindow);
        int x = locationInWindow[0];
        int y = locationInWindow[1];
        Rect boundsInWindow = new Rect(x, y, x + $this$generateBitmapFromPixelCopy.getWidth(), y + $this$generateBitmapFromPixelCopy.getHeight());
        WindowCapture.generateBitmapFromPixelCopy(window, boundsInWindow, destBitmap, bitmapFuture);
    }

    private static final Activity getActivity$getActivity(Context $this$getActivity_u24getActivity) {
        Activity activity;
        Context context = $this$getActivity_u24getActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$getActivity_u24getActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$getActivity_u24getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            activity = ViewCapture.getActivity$getActivity(context2);
        } else {
            activity = null;
        }
        return activity;
    }

    public static final /* synthetic */ void access$generateBitmap(View $receiver, ResolvableFuture bitmapFuture) {
        ViewCapture.generateBitmap($receiver, (ResolvableFuture<Bitmap>)bitmapFuture);
    }
}

