/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.app;

import android.app.Activity;
import android.app.Instrumentation;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.test.core.app.ApplicationProvider;
import androidx.test.core.app.InstrumentationActivityInvoker$$ExternalSyntheticLambda0;
import androidx.test.core.app.InstrumentationActivityInvoker$$ExternalSyntheticLambda1;
import androidx.test.core.app.InstrumentationActivityInvoker$$ExternalSyntheticLambda2;
import androidx.test.internal.platform.app.ActivityInvoker;
import androidx.test.internal.platform.app.ActivityLifecycleTimeout;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class InstrumentationActivityInvoker
implements ActivityInvoker {
    private static final String TARGET_ACTIVITY_INTENT_KEY = "androidx.test.core.app.InstrumentationActivityInvoker.START_TARGET_ACTIVITY_INTENT_KEY";
    private static final String TARGET_ACTIVITY_OPTIONS_BUNDLE_KEY = "androidx.test.core.app.InstrumentationActivityInvoker.TARGET_ACTIVITY_OPTIONS_BUNDLE_KEY";
    private static final String BOOTSTRAP_ACTIVITY_RESULT_RECEIVED = "androidx.test.core.app.InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_RECEIVED";
    private static final String BOOTSTRAP_ACTIVITY_RESULT_CODE_KEY = "androidx.test.core.app.InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_CODE_KEY";
    private static final String BOOTSTRAP_ACTIVITY_RESULT_DATA_KEY = "androidx.test.core.app.InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_DATA_KEY";
    private static final String CANCEL_ACTIVITY_RESULT_WAITER = "androidx.test.core.app.InstrumentationActivityInvoker.CANCEL_ACTIVITY_RESULT_WAITER";
    private static final String EMPTY_ACTIVITY_RESUMED = "androidx.test.core.app.InstrumentationActivityInvoker.EMPTY_ACTIVITY_RESUMED";
    private static final String EMPTY_FLOATING_ACTIVITY_RESUMED = "androidx.test.core.app.InstrumentationActivityInvoker.EMPTY_FLOATING_ACTIVITY_RESUMED";
    private static final String FINISH_BOOTSTRAP_ACTIVITY = "androidx.test.core.app.InstrumentationActivityInvoker.FINISH_BOOTSTRAP_ACTIVITY";
    private static final String FINISH_EMPTY_ACTIVITIES = "androidx.test.core.app.InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES";
    @Nullable
    private ActivityResultWaiter activityResultWaiter;

    public Instrumentation.ActivityResult getActivityResult() {
        return ((ActivityResultWaiter)Checks.checkNotNull((Object)this.activityResultWaiter, (Object)"You must start Activity first")).getActivityResult();
    }

    public /* synthetic */ Intent getIntentForActivity(Class clazz) {
        return ActivityInvoker.-CC.$default$getIntentForActivity((ActivityInvoker)this, (Class)clazz);
    }

    InstrumentationActivityInvoker() {
    }

    private static void checkActivityStageIsIn(Activity activity, Set<Stage> expected) {
        Set<Stage> set = expected;
        Activity activity2 = activity;
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new InstrumentationActivityInvoker$$ExternalSyntheticLambda1(activity2, set));
    }

    private static void checkActivityStageIsIn(Activity activity, Stage ... expected) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, new HashSet<Stage>(Arrays.asList(expected)));
    }

    public void finishActivity(Activity activity) {
        this.startEmptyActivitySync();
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Activity activity2 = activity;
        activity2.getClass();
        Activity activity3 = activity2;
        instrumentation.runOnMainSync((Runnable)new InstrumentationActivityInvoker$$ExternalSyntheticLambda2(activity3));
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_BOOTSTRAP_ACTIVITY));
        this.startEmptyActivitySync();
        Instrumentation instrumentation2 = InstrumentationRegistry.getInstrumentation();
        Activity activity4 = activity;
        activity4.getClass();
        activity3 = activity4;
        instrumentation2.runOnMainSync((Runnable)new InstrumentationActivityInvoker$$ExternalSyntheticLambda2(activity3));
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(CANCEL_ACTIVITY_RESULT_WAITER));
    }

    static /* synthetic */ void lambda$checkActivityStageIsIn$0(Activity activity, Set expected) {
        Stage stage = ActivityLifecycleMonitorRegistry.getInstance().getLifecycleStageOf(activity);
        Checks.checkState((boolean)expected.contains(stage), (String)"Activity's stage must be %s but was %s", (Object[])new Object[]{expected, stage});
    }

    public void pauseActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED);
        this.startFloatingEmptyActivitySync();
    }

    public void recreateActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Activity activity2 = activity;
        activity2.getClass();
        Activity activity3 = activity2;
        instrumentation.runOnMainSync((Runnable)new InstrumentationActivityInvoker$$ExternalSyntheticLambda0(activity3));
    }

    public void resumeActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
    }

    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    public void startActivity(Intent intent, @Nullable Bundle activityOptions) {
        ActivityInfo ai = intent.resolveActivityInfo(ApplicationProvider.getApplicationContext().getPackageManager(), 0);
        if (ai == null) {
            String string = String.valueOf(intent);
            throw new RuntimeException("Unable to resolve activity for: " + string);
        }
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_BOOTSTRAP_ACTIVITY));
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
        this.activityResultWaiter = new ActivityResultWaiter((Context)ApplicationProvider.getApplicationContext());
        Intent bootstrapIntent = this.getIntentForActivity(BootstrapActivity.class).setFlags(0x10008000).putExtra(TARGET_ACTIVITY_INTENT_KEY, (Parcelable)PendingIntent.getActivity(ApplicationProvider.getApplicationContext(), (int)0, (Intent)intent, (int)0xA000000)).putExtra(TARGET_ACTIVITY_OPTIONS_BUNDLE_KEY, activityOptions);
        if (Build.VERSION.SDK_INT < 16) {
            ApplicationProvider.getApplicationContext().startActivity(bootstrapIntent);
        } else {
            ApplicationProvider.getApplicationContext().startActivity(bootstrapIntent, activityOptions);
        }
    }

    private void startEmptyActivitySync() {
        final CountDownLatch latch = new CountDownLatch(1);
        BroadcastReceiver receiver = new BroadcastReceiver(this){

            public void onReceive(Context context, Intent intent) {
                latch.countDown();
            }
        };
        ApplicationProvider.getApplicationContext().registerReceiver(receiver, new IntentFilter(EMPTY_ACTIVITY_RESUMED));
        ApplicationProvider.getApplicationContext().startActivity(this.getIntentForActivity(EmptyActivity.class).setFlags(0x10000000));
        try {
            latch.await(ActivityLifecycleTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to stop activity", e);
        }
        finally {
            ApplicationProvider.getApplicationContext().unregisterReceiver(receiver);
        }
    }

    private void startFloatingEmptyActivitySync() {
        final CountDownLatch latch = new CountDownLatch(1);
        BroadcastReceiver receiver = new BroadcastReceiver(this){

            public void onReceive(Context context, Intent intent) {
                latch.countDown();
            }
        };
        ApplicationProvider.getApplicationContext().registerReceiver(receiver, new IntentFilter(EMPTY_FLOATING_ACTIVITY_RESUMED));
        ApplicationProvider.getApplicationContext().startActivity(this.getIntentForActivity(EmptyFloatingActivity.class).setFlags(0x10000000));
        try {
            latch.await(ActivityLifecycleTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to pause activity", e);
        }
        finally {
            ApplicationProvider.getApplicationContext().unregisterReceiver(receiver);
        }
    }

    public void stopActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        this.startEmptyActivitySync();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ActivityResultWaiter {
        private static final String TAG = ActivityResultWaiter.class.getName();
        private final CountDownLatch latch = new CountDownLatch(1);
        @Nullable
        private Instrumentation.ActivityResult activityResult;

        public Instrumentation.ActivityResult getActivityResult() {
            try {
                this.latch.await(ActivityLifecycleTimeout.getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Log.i((String)TAG, (String)"Waiting activity result was interrupted", (Throwable)e);
            }
            Checks.checkNotNull((Object)this.activityResult, (String)"onActivityResult never be called after %d milliseconds", (Object[])new Object[]{ActivityLifecycleTimeout.getMillis()});
            return this.activityResult;
        }

        public ActivityResultWaiter(Context context) {
            BroadcastReceiver receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    context.unregisterReceiver((BroadcastReceiver)this);
                    if (InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_RECEIVED.equals(intent.getAction())) {
                        int resultCode = intent.getIntExtra(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_CODE_KEY, 0);
                        Intent resultData = (Intent)intent.getParcelableExtra(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_DATA_KEY);
                        if (resultData != null) {
                            resultData = new Intent(resultData);
                        }
                        ActivityResultWaiter.this.activityResult = new Instrumentation.ActivityResult(resultCode, resultData);
                        ActivityResultWaiter.this.latch.countDown();
                    }
                }
            };
            IntentFilter intentFilter = new IntentFilter(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_RECEIVED);
            intentFilter.addAction(InstrumentationActivityInvoker.CANCEL_ACTIVITY_RESULT_WAITER);
            context.registerReceiver(receiver, intentFilter);
        }
    }

    public static class BootstrapActivity
    extends Activity {
        private static final String TAG = BootstrapActivity.class.getName();
        private static final String IS_TARGET_ACTIVITY_STARTED_KEY = "IS_TARGET_ACTIVITY_STARTED_KEY";
        private final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BootstrapActivity.this.finishActivity(0);
                BootstrapActivity.this.finish();
            }
        };
        private boolean isTargetActivityStarted;

        public void finish() {
            super.finish();
            this.overridePendingTransition(0, 0);
        }

        protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
            if (requestCode == 0) {
                Intent activityResultReceivedActionIntent = new Intent(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_RECEIVED);
                activityResultReceivedActionIntent.putExtra(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_CODE_KEY, resultCode);
                if (data != null) {
                    activityResultReceivedActionIntent.putExtra(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_DATA_KEY, (Parcelable)data);
                }
                this.sendBroadcast(activityResultReceivedActionIntent);
                this.finish();
            }
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.registerReceiver(this.receiver, new IntentFilter(InstrumentationActivityInvoker.FINISH_BOOTSTRAP_ACTIVITY));
            this.isTargetActivityStarted = savedInstanceState != null && savedInstanceState.getBoolean(IS_TARGET_ACTIVITY_STARTED_KEY, false);
            this.overridePendingTransition(0, 0);
        }

        protected void onDestroy() {
            super.onDestroy();
            this.unregisterReceiver(this.receiver);
        }

        protected void onResume() {
            super.onResume();
            if (!this.isTargetActivityStarted) {
                this.isTargetActivityStarted = true;
                PendingIntent startTargetActivityIntent = (PendingIntent)Checks.checkNotNull((Object)((PendingIntent)this.getIntent().getParcelableExtra(InstrumentationActivityInvoker.TARGET_ACTIVITY_INTENT_KEY)));
                Bundle options = this.getIntent().getBundleExtra(InstrumentationActivityInvoker.TARGET_ACTIVITY_OPTIONS_BUNDLE_KEY);
                try {
                    if (options == null || Build.VERSION.SDK_INT < 16) {
                        this.startIntentSenderForResult(startTargetActivityIntent.getIntentSender(), 0, null, 0x10000000, 0, 0);
                    } else {
                        this.startIntentSenderForResult(startTargetActivityIntent.getIntentSender(), 0, null, 0x10000000, 0, 0, options);
                    }
                }
                catch (IntentSender.SendIntentException e) {
                    Log.e((String)TAG, (String)"Failed to start target activity.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        protected void onSaveInstanceState(Bundle outState) {
            super.onSaveInstanceState(outState);
            outState.putBoolean(IS_TARGET_ACTIVITY_STARTED_KEY, this.isTargetActivityStarted);
        }
    }

    public static class EmptyFloatingActivity
    extends Activity {
        private final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                EmptyFloatingActivity.this.finish();
            }
        };

        public void finish() {
            super.finish();
            this.overridePendingTransition(0, 0);
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.registerReceiver(this.receiver, new IntentFilter(InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES));
            this.overridePendingTransition(0, 0);
        }

        protected void onDestroy() {
            super.onDestroy();
            this.unregisterReceiver(this.receiver);
        }

        protected void onResume() {
            super.onResume();
            this.sendBroadcast(new Intent(InstrumentationActivityInvoker.EMPTY_FLOATING_ACTIVITY_RESUMED));
        }
    }

    public static class EmptyActivity
    extends Activity {
        private final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                EmptyActivity.this.finish();
            }
        };

        public void finish() {
            super.finish();
            this.overridePendingTransition(0, 0);
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.registerReceiver(this.receiver, new IntentFilter(InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES));
            this.overridePendingTransition(0, 0);
        }

        protected void onDestroy() {
            super.onDestroy();
            this.unregisterReceiver(this.receiver);
        }

        protected void onResume() {
            super.onResume();
            this.sendBroadcast(new Intent(InstrumentationActivityInvoker.EMPTY_ACTIVITY_RESUMED));
        }
    }
}

