/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.app;

import android.app.UiAutomation;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Choreographer;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.core.app.ListFuture;
import androidx.test.core.internal.os.HandlerExecutor;
import androidx.test.core.view.ViewCapture;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.platform.graphics.HardwareRendererCompat;
import androidx.test.platform.view.inspector.WindowInspectorCompat;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0007\u001a\u001c\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u001a\b\u0010\b\u001a\u00020\tH\u0007\u001a\b\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"canTakeScreenshot", "", "forceRedrawGlobalWindowViews", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "Ljava/lang/Void;", "mainExecutor", "Ljava/util/concurrent/Executor;", "takeScreenshot", "Landroid/graphics/Bitmap;", "takeScreenshotNoSync", "core_java_androidx_test_core-core_internal_kt"})
@JvmName(name="DeviceCapture")
public final class DeviceCapture {
    @ExperimentalTestApi
    public static final boolean canTakeScreenshot() {
        return Build.VERSION.SDK_INT >= 18 && InstrumentationRegistry.getInstrumentation().getUiAutomation() != null && !Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
    }

    @ExperimentalTestApi
    @RequiresApi(value=18)
    @NotNull
    public static final Bitmap takeScreenshot() throws RuntimeException {
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        return DeviceCapture.takeScreenshotNoSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalTestApi
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=18)
    @NotNull
    public static final Bitmap takeScreenshotNoSync() throws RuntimeException {
        Checks.checkState((boolean)DeviceCapture.canTakeScreenshot());
        HandlerExecutor mainExecutor = new HandlerExecutor(new Handler(Looper.getMainLooper()));
        UiAutomation uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
        if (uiAutomation == null) {
            throw new RuntimeException("uiautomation is null");
        }
        boolean origIsDrawingEnabled = HardwareRendererCompat.isDrawingEnabled();
        try {
            if (!origIsDrawingEnabled) {
                HardwareRendererCompat.setDrawingEnabled((boolean)true);
            }
            try {
                DeviceCapture.forceRedrawGlobalWindowViews(mainExecutor).get(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Log.w((String)"takeScreenshot", (String)"force redraw failed. Proceeding with screenshot", (Throwable)e);
            }
            CountDownLatch latch = new CountDownLatch(1);
            mainExecutor.execute(new Runnable(latch){
                final /* synthetic */ CountDownLatch $latch;
                {
                    this.$latch = $latch;
                }

                public final void run() {
                    Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(this.$latch){
                        final /* synthetic */ CountDownLatch $latch;
                        {
                            this.$latch = $latch;
                        }

                        public final void doFrame(long it) {
                            this.$latch.countDown();
                        }
                    });
                }
            });
            if (!latch.await(1L, TimeUnit.SECONDS)) {
                Log.w((String)"takeScreenshot", (String)"frame callback did not occur in 1 seconds. Proceeding with screenshot");
            }
            for (int i = 1; i < 4; ++i) {
                Bitmap bitmap = uiAutomation.takeScreenshot();
                if (bitmap == null) continue;
                Bitmap bitmap2 = bitmap;
                return bitmap2;
            }
            throw new RuntimeException("uiAutomation.takeScreenshot failed to return a bitmap");
        }
        finally {
            HardwareRendererCompat.setDrawingEnabled((boolean)origIsDrawingEnabled);
        }
    }

    @RequiresApi(value=18)
    private static final ListenableFuture<List<Void>> forceRedrawGlobalWindowViews(Executor mainExecutor) {
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableFuture, (String)"create()");
        ResolvableFuture future = resolvableFuture;
        mainExecutor.execute(new Runnable((ResolvableFuture<List<Void>>)future, mainExecutor){
            final /* synthetic */ ResolvableFuture<List<Void>> $future;
            final /* synthetic */ Executor $mainExecutor;
            {
                this.$future = $future;
                this.$mainExecutor = $mainExecutor;
            }

            public final void run() {
                List views = WindowInspectorCompat.getGlobalWindowViews();
                List viewFutures = new ArrayList<E>();
                for (View view : views) {
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                    viewFutures.add(ViewCapture.forceRedraw(view));
                }
                Log.d((String)"takeScreenshot", (String)("Found " + views.size() + " global views to redraw"));
                this.$future.setFuture((ListenableFuture)new ListFuture<V>(viewFutures, true, this.$mainExecutor));
            }
        });
        return (ListenableFuture)future;
    }
}

