/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.content.pm;

import android.annotation.TargetApi;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.test.core.content.pm.ApplicationInfoBuilder;
import androidx.test.internal.util.Checks;
import java.util.HashMap;
import java.util.Map;

public final class PackageInfoBuilder {
    @Nullable
    private String packageName;
    @Nullable
    private ApplicationInfo applicationInfo;
    private long longVersionCode = 0L;
    @Nullable
    private String versionName;
    private final Map<String, Integer> requestedPermissionsMap = new HashMap<String, Integer>();

    private PackageInfoBuilder() {
    }

    public static PackageInfoBuilder newBuilder() {
        return new PackageInfoBuilder();
    }

    public PackageInfoBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    @TargetApi(value=28)
    public PackageInfoBuilder setVersionCode(long longVersionCode) {
        this.longVersionCode = longVersionCode;
        return this;
    }

    public PackageInfoBuilder setVersionName(String versionName) {
        this.versionName = versionName;
        return this;
    }

    @TargetApi(value=16)
    public PackageInfoBuilder addRequestedPermission(String requestedPermission, int requestedPermissionFlag) {
        this.requestedPermissionsMap.put(requestedPermission, requestedPermissionFlag);
        return this;
    }

    public PackageInfoBuilder setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    public PackageInfo build() {
        Checks.checkNotNull((Object)this.packageName, (Object)"Mandatory field 'packageName' missing.");
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = this.packageName;
        packageInfo.versionName = this.versionName;
        if (Build.VERSION.SDK_INT >= 28) {
            packageInfo.setLongVersionCode(this.longVersionCode);
        } else {
            packageInfo.versionCode = (int)this.longVersionCode;
        }
        if (this.applicationInfo == null) {
            this.applicationInfo = ApplicationInfoBuilder.newBuilder().setPackageName(this.packageName).build();
        }
        packageInfo.applicationInfo = this.applicationInfo;
        packageInfo.requestedPermissions = this.requestedPermissionsMap.keySet().toArray(new String[0]);
        if (Build.VERSION.SDK_INT >= 16) {
            Integer[] requestedPermissionsFlags = this.requestedPermissionsMap.values().toArray(new Integer[0]);
            int[] requestedPermissionsFlagsIntArray = new int[requestedPermissionsFlags.length];
            for (int i = 0; i < requestedPermissionsFlags.length; ++i) {
                requestedPermissionsFlagsIntArray[i] = requestedPermissionsFlags[i];
            }
            packageInfo.requestedPermissionsFlags = requestedPermissionsFlagsIntArray;
        }
        Checks.checkState((boolean)packageInfo.packageName.equals(packageInfo.applicationInfo.packageName), (Object)"Field 'packageName' must match field 'applicationInfo.packageName'");
        return packageInfo;
    }
}

