/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.view;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.core.internal.os.HandlerExecutor;
import androidx.test.core.view.ViewCapture;
import androidx.test.internal.platform.reflect.ReflectiveField;
import androidx.test.internal.platform.reflect.ReflectiveMethod;
import androidx.test.platform.graphics.HardwareRendererCompat;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007\u001a\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u0003H\u0007\u001a&\u0010\b\u001a\u00020\t*\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a,\u0010\f\u001a\u00020\t*\u00020\u00032\u0006\u0010\r\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a,\u0010\u000e\u001a\u00020\t*\u00020\u00032\u0006\u0010\r\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0003\u001a4\u0010\u000e\u001a\u00020\t*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0003\u001a,\u0010\u0011\u001a\u00020\t*\u00020\u00122\u0006\u0010\r\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0003\u001a\f\u0010\u0013\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0003H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0003\u00a8\u0006\u0019"}, d2={"captureToBitmap", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroid/graphics/Bitmap;", "Landroid/view/View;", "rect", "Landroid/graphics/Rect;", "forceRedraw", "Ljava/lang/Void;", "generateBitmap", "", "bitmapFuture", "Landroidx/concurrent/futures/ResolvableFuture;", "generateBitmapFromDraw", "destBitmap", "generateBitmapFromPixelCopy", "surface", "Landroid/view/Surface;", "generateBitmapFromSurfaceViewPixelCopy", "Landroid/view/SurfaceView;", "getBoundsInSurface", "getBoundsInWindow", "getSurface", "reflectivelyGetLocationInSurface", "locationInSurface", "", "core_java_androidx_test_core-core_internal_kt"})
@JvmName(name="ViewCapture")
public final class ViewCapture {
    @ExperimentalTestApi
    @RequiresApi(value=16)
    @NotNull
    public static final ListenableFuture<Bitmap> captureToBitmap(@NotNull View $this$captureToBitmap, @Nullable Rect rect) {
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableFuture, (String)"create()");
        ResolvableFuture bitmapFuture = resolvableFuture;
        HandlerExecutor mainExecutor = new HandlerExecutor(new Handler(Looper.getMainLooper()));
        if (!HardwareRendererCompat.isDrawingEnabled()) {
            HardwareRendererCompat.setDrawingEnabled((boolean)true);
            bitmapFuture.addListener((Runnable)captureToBitmap.1.INSTANCE, (Executor)mainExecutor);
        }
        mainExecutor.execute(new Runnable($this$captureToBitmap, (ResolvableFuture<Bitmap>)bitmapFuture, rect, mainExecutor){
            final /* synthetic */ View $this_captureToBitmap;
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            final /* synthetic */ Rect $rect;
            final /* synthetic */ HandlerExecutor $mainExecutor;
            {
                this.$this_captureToBitmap = $receiver;
                this.$bitmapFuture = $bitmapFuture;
                this.$rect = $rect;
                this.$mainExecutor = $mainExecutor;
            }

            public final void run() {
                String string = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"robolectric", (boolean)false, (int)2, null)) {
                    ViewCapture.access$generateBitmap(this.$this_captureToBitmap, this.$bitmapFuture, this.$rect);
                } else {
                    ListenableFuture<Void> forceRedrawFuture = ViewCapture.forceRedraw(this.$this_captureToBitmap);
                    forceRedrawFuture.addListener(new Runnable(this.$this_captureToBitmap, this.$bitmapFuture, this.$rect){
                        final /* synthetic */ View $this_captureToBitmap;
                        final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
                        final /* synthetic */ Rect $rect;
                        {
                            this.$this_captureToBitmap = $receiver;
                            this.$bitmapFuture = $bitmapFuture;
                            this.$rect = $rect;
                        }

                        public final void run() {
                            ViewCapture.access$generateBitmap(this.$this_captureToBitmap, this.$bitmapFuture, this.$rect);
                        }
                    }, (Executor)this.$mainExecutor);
                }
            }
        });
        return (ListenableFuture)bitmapFuture;
    }

    public static /* synthetic */ ListenableFuture captureToBitmap$default(View view, Rect rect, int n, Object object) {
        if ((n & 1) != 0) {
            rect = null;
        }
        return ViewCapture.captureToBitmap(view, rect);
    }

    @RequiresApi(value=16)
    @ExperimentalTestApi
    @NotNull
    public static final ListenableFuture<Void> forceRedraw(@NotNull View $this$forceRedraw) {
        Intrinsics.checkNotNullParameter((Object)$this$forceRedraw, (String)"<this>");
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableFuture, (String)"create()");
        ResolvableFuture future = resolvableFuture;
        if (Build.VERSION.SDK_INT >= 29 && $this$forceRedraw.isHardwareAccelerated()) {
            $this$forceRedraw.getViewTreeObserver().registerFrameCommitCallback(new Runnable((ResolvableFuture<Void>)future){
                final /* synthetic */ ResolvableFuture<Void> $future;
                {
                    this.$future = $future;
                }

                public final void run() {
                    this.$future.set(null);
                }
            });
        } else {
            $this$forceRedraw.getViewTreeObserver().addOnDrawListener(new ViewTreeObserver.OnDrawListener((ResolvableFuture<Void>)future, $this$forceRedraw){
                private boolean handled;
                final /* synthetic */ ResolvableFuture<Void> $future;
                final /* synthetic */ View $this_forceRedraw;
                {
                    this.$future = $future;
                    this.$this_forceRedraw = $receiver;
                }

                public final boolean getHandled() {
                    return this.handled;
                }

                public final void setHandled(boolean bl) {
                    this.handled = bl;
                }

                public void onDraw() {
                    if (!this.handled) {
                        this.handled = true;
                        this.$future.set(null);
                        new Handler(Looper.getMainLooper()).post(new Runnable(this.$this_forceRedraw, this){
                            final /* synthetic */ View $this_forceRedraw;
                            final /* synthetic */ forceRedraw.2 this$0;
                            {
                                this.$this_forceRedraw = $receiver;
                                this.this$0 = $receiver2;
                            }

                            public final void run() {
                                this.$this_forceRedraw.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.this$0);
                            }
                        });
                    }
                }
            });
        }
        $this$forceRedraw.invalidate();
        return (ListenableFuture)future;
    }

    private static final void generateBitmap(View $this$generateBitmap, ResolvableFuture<Bitmap> bitmapFuture, Rect rect) {
        if (bitmapFuture.isCancelled()) {
            return;
        }
        Rect rect2 = rect;
        int rectWidth = rect2 != null ? rect2.width() : $this$generateBitmap.getWidth();
        Rect rect3 = rect;
        int rectHeight = rect3 != null ? rect3.height() : $this$generateBitmap.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)rectWidth, (int)rectHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(rectWidth, \u2026 Bitmap.Config.ARGB_8888)");
        Bitmap destBitmap = bitmap;
        if (Build.VERSION.SDK_INT < 26) {
            ViewCapture.generateBitmapFromDraw($this$generateBitmap, destBitmap, bitmapFuture, rect);
        } else if (Build.VERSION.SDK_INT >= 34) {
            ViewCapture.generateBitmapFromPixelCopy($this$generateBitmap, destBitmap, bitmapFuture, rect);
        } else if ($this$generateBitmap instanceof SurfaceView) {
            ViewCapture.generateBitmapFromSurfaceViewPixelCopy((SurfaceView)$this$generateBitmap, destBitmap, bitmapFuture, rect);
        } else {
            ViewCapture.generateBitmapFromPixelCopy($this$generateBitmap, ViewCapture.getSurface($this$generateBitmap), destBitmap, bitmapFuture, rect);
        }
    }

    static /* synthetic */ void generateBitmap$default(View view, ResolvableFuture resolvableFuture, Rect rect, int n, Object object) {
        if ((n & 2) != 0) {
            rect = null;
        }
        ViewCapture.generateBitmap(view, (ResolvableFuture<Bitmap>)resolvableFuture, rect);
    }

    @RequiresApi(value=26)
    private static final void generateBitmapFromSurfaceViewPixelCopy(SurfaceView $this$generateBitmapFromSurfaceViewPixelCopy, Bitmap destBitmap, ResolvableFuture<Bitmap> bitmapFuture, Rect rect) {
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(bitmapFuture, destBitmap){
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            final /* synthetic */ Bitmap $destBitmap;
            {
                this.$bitmapFuture = $bitmapFuture;
                this.$destBitmap = $destBitmap;
            }

            public final void onPixelCopyFinished(int result) {
                if (result == 0) {
                    this.$bitmapFuture.set((Object)this.$destBitmap);
                } else {
                    String string = "PixelCopy failed: %d";
                    Object[] objectArray = new Object[]{result};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    this.$bitmapFuture.setException((Throwable)new RuntimeException(string2));
                }
            }
        };
        PixelCopy.request((SurfaceView)$this$generateBitmapFromSurfaceViewPixelCopy, (Rect)rect, (Bitmap)destBitmap, (PixelCopy.OnPixelCopyFinishedListener)onCopyFinished2, (Handler)$this$generateBitmapFromSurfaceViewPixelCopy.getHandler());
    }

    public static final void generateBitmapFromDraw(@NotNull View $this$generateBitmapFromDraw, @NotNull Bitmap destBitmap, @NotNull ResolvableFuture<Bitmap> bitmapFuture, @Nullable Rect rect) {
        Intrinsics.checkNotNullParameter((Object)$this$generateBitmapFromDraw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destBitmap, (String)"destBitmap");
        Intrinsics.checkNotNullParameter(bitmapFuture, (String)"bitmapFuture");
        destBitmap.setDensity($this$generateBitmapFromDraw.getResources().getDisplayMetrics().densityDpi);
        $this$generateBitmapFromDraw.computeScroll();
        Canvas canvas = new Canvas(destBitmap);
        canvas.translate((float)(-$this$generateBitmapFromDraw.getScrollX()), (float)(-$this$generateBitmapFromDraw.getScrollY()));
        if (rect != null) {
            canvas.translate((float)(-rect.left), (float)(-rect.top));
        }
        $this$generateBitmapFromDraw.draw(canvas);
        bitmapFuture.set((Object)destBitmap);
    }

    @RequiresApi(value=26)
    private static final void generateBitmapFromPixelCopy(View $this$generateBitmapFromPixelCopy, Surface surface, Bitmap destBitmap, ResolvableFuture<Bitmap> bitmapFuture, Rect rect) {
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(bitmapFuture, destBitmap){
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            final /* synthetic */ Bitmap $destBitmap;
            {
                this.$bitmapFuture = $bitmapFuture;
                this.$destBitmap = $destBitmap;
            }

            public final void onPixelCopyFinished(int result) {
                if (result == 0) {
                    this.$bitmapFuture.set((Object)this.$destBitmap);
                } else {
                    this.$bitmapFuture.setException((Throwable)new RuntimeException("PixelCopy failed: " + result));
                }
            }
        };
        Rect bounds = ViewCapture.getBoundsInSurface($this$generateBitmapFromPixelCopy);
        if (rect != null) {
            bounds = new Rect(bounds.left + rect.left, bounds.top + rect.top, bounds.left + rect.right, bounds.top + rect.bottom);
        }
        PixelCopy.request((Surface)surface, (Rect)bounds, (Bitmap)destBitmap, (PixelCopy.OnPixelCopyFinishedListener)onCopyFinished2, (Handler)new Handler(Looper.getMainLooper()));
    }

    private static final Rect getBoundsInWindow(View $this$getBoundsInWindow) {
        int[] nArray = new int[]{0, 0};
        int[] locationInWindow = nArray;
        $this$getBoundsInWindow.getLocationInWindow(locationInWindow);
        int x = locationInWindow[0];
        int y = locationInWindow[1];
        return new Rect(x, y, x + $this$getBoundsInWindow.getWidth(), y + $this$getBoundsInWindow.getHeight());
    }

    private static final Rect getBoundsInSurface(View $this$getBoundsInSurface) {
        int[] nArray = new int[]{0, 0};
        int[] locationInSurface = nArray;
        if (Build.VERSION.SDK_INT < 29) {
            ViewCapture.reflectivelyGetLocationInSurface($this$getBoundsInSurface, locationInSurface);
        } else {
            $this$getBoundsInSurface.getLocationInSurface(locationInSurface);
        }
        int x = locationInSurface[0];
        int y = locationInSurface[1];
        Rect bounds = new Rect(x, y, x + $this$getBoundsInSurface.getWidth(), y + $this$getBoundsInSurface.getHeight());
        Log.d((String)"ViewCapture", (String)("getBoundsInSurface " + bounds));
        return bounds;
    }

    private static final Surface getSurface(View $this$getSurface) {
        Object viewRootImpl = new ReflectiveMethod(View.class, "getViewRootImpl", new Class[0]).invoke((Object)$this$getSurface, new Object[0]);
        Object object = new ReflectiveField("android.view.ViewRootImpl", "mSurface").get(viewRootImpl);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReflectiveField<Surface>\u2026rface\").get(viewRootImpl)");
        return (Surface)object;
    }

    @SuppressLint(value={"NewApi"})
    private static final void reflectivelyGetLocationInSurface(View $this$reflectivelyGetLocationInSurface, int[] locationInSurface) {
        $this$reflectivelyGetLocationInSurface.getLocationInWindow(locationInSurface);
        if (Build.VERSION.SDK_INT < 28) {
            Object viewRootImpl = new ReflectiveMethod(View.class, "getViewRootImpl", new Class[0]).invoke((Object)$this$reflectivelyGetLocationInSurface, new Object[0]);
            WindowManager.LayoutParams windowAttributes = (WindowManager.LayoutParams)new ReflectiveField("android.view.ViewRootImpl", "mWindowAttributes").get(viewRootImpl);
            Rect surfaceInsets = (Rect)new ReflectiveField(WindowManager.LayoutParams.class, "surfaceInsets").get((Object)windowAttributes);
            locationInSurface[0] = locationInSurface[0] + surfaceInsets.left;
            locationInSurface[1] = locationInSurface[1] + surfaceInsets.top;
        } else {
            Log.w((String)"ViewCapture", (String)"Could not calculate offset of view in surface on API 28, resulting image may have incorrect positioning");
        }
    }

    @RequiresApi(value=34)
    private static final void generateBitmapFromPixelCopy(View $this$generateBitmapFromPixelCopy, Bitmap destBitmap, ResolvableFuture<Bitmap> bitmapFuture, Rect rect) {
        PixelCopy.Request.Builder builder = PixelCopy.Request.Builder.ofWindow((View)$this$generateBitmapFromPixelCopy);
        Rect rect2 = rect;
        if (rect2 == null) {
            rect2 = ViewCapture.getBoundsInWindow($this$generateBitmapFromPixelCopy);
        }
        PixelCopy.Request request = builder.setSourceRect(rect2).setDestinationBitmap(destBitmap).build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"ofWindow(this)\n      .se\u2026estBitmap)\n      .build()");
        PixelCopy.Request request2 = request;
        HandlerExecutor mainExecutor = new HandlerExecutor(new Handler(Looper.getMainLooper()));
        Consumer onCopyFinished2 = new Consumer(bitmapFuture){
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            {
                this.$bitmapFuture = $bitmapFuture;
            }

            public final void accept(PixelCopy.Result result) {
                if (result.getStatus() == 0) {
                    this.$bitmapFuture.set((Object)result.getBitmap());
                } else {
                    this.$bitmapFuture.setException((Throwable)new RuntimeException("PixelCopy failed: $(result.status)"));
                }
            }
        };
        PixelCopy.request((PixelCopy.Request)request2, (Executor)mainExecutor, (Consumer)onCopyFinished2);
    }

    public static final /* synthetic */ void access$generateBitmap(View $receiver, ResolvableFuture bitmapFuture, Rect rect) {
        ViewCapture.generateBitmap($receiver, (ResolvableFuture<Bitmap>)bitmapFuture, rect);
    }
}

