/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.view;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.core.internal.os.HandlerExecutor;
import androidx.test.core.view.ViewCapture;
import androidx.test.core.view.WindowCapture;
import androidx.test.platform.graphics.HardwareRendererCompat;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007\u001a&\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0000\u001a.\u0010\n\u001a\u00020\u0007*\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0000\u00a8\u0006\f"}, d2={"captureRegionToBitmap", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroid/graphics/Bitmap;", "Landroid/view/Window;", "boundsInWindow", "Landroid/graphics/Rect;", "generateBitmap", "", "bitmapFuture", "Landroidx/concurrent/futures/ResolvableFuture;", "generateBitmapFromPixelCopy", "destBitmap", "core_java_androidx_test_core-core_internal_kt"})
@JvmName(name="WindowCapture")
public final class WindowCapture {
    @ExperimentalTestApi
    @RequiresApi(value=16)
    @NotNull
    public static final ListenableFuture<Bitmap> captureRegionToBitmap(@NotNull Window $this$captureRegionToBitmap, @Nullable Rect boundsInWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$captureRegionToBitmap, (String)"<this>");
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableFuture, (String)"create()");
        ResolvableFuture bitmapFuture = resolvableFuture;
        HandlerExecutor mainExecutor = new HandlerExecutor(new Handler(Looper.getMainLooper()));
        if (!HardwareRendererCompat.isDrawingEnabled()) {
            HardwareRendererCompat.setDrawingEnabled((boolean)true);
            bitmapFuture.addListener((Runnable)captureRegionToBitmap.1.INSTANCE, (Executor)mainExecutor);
        }
        mainExecutor.execute(new Runnable($this$captureRegionToBitmap, mainExecutor, boundsInWindow, (ResolvableFuture<Bitmap>)bitmapFuture){
            final /* synthetic */ Window $this_captureRegionToBitmap;
            final /* synthetic */ HandlerExecutor $mainExecutor;
            final /* synthetic */ Rect $boundsInWindow;
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            {
                this.$this_captureRegionToBitmap = $receiver;
                this.$mainExecutor = $mainExecutor;
                this.$boundsInWindow = $boundsInWindow;
                this.$bitmapFuture = $bitmapFuture;
            }

            public final void run() {
                View view = this.$this_captureRegionToBitmap.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"decorView");
                ListenableFuture<Void> forceRedrawFuture = ViewCapture.forceRedraw(view);
                forceRedrawFuture.addListener(new Runnable(this.$this_captureRegionToBitmap, this.$boundsInWindow, this.$bitmapFuture){
                    final /* synthetic */ Window $this_captureRegionToBitmap;
                    final /* synthetic */ Rect $boundsInWindow;
                    final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
                    {
                        this.$this_captureRegionToBitmap = $receiver;
                        this.$boundsInWindow = $boundsInWindow;
                        this.$bitmapFuture = $bitmapFuture;
                    }

                    public final void run() {
                        WindowCapture.generateBitmap(this.$this_captureRegionToBitmap, this.$boundsInWindow, this.$bitmapFuture);
                    }
                }, (Executor)this.$mainExecutor);
            }
        });
        return (ListenableFuture)bitmapFuture;
    }

    public static /* synthetic */ ListenableFuture captureRegionToBitmap$default(Window window, Rect rect, int n, Object object) {
        if ((n & 1) != 0) {
            rect = null;
        }
        return WindowCapture.captureRegionToBitmap(window, rect);
    }

    public static final void generateBitmap(@NotNull Window $this$generateBitmap, @Nullable Rect boundsInWindow, @NotNull ResolvableFuture<Bitmap> bitmapFuture) {
        Intrinsics.checkNotNullParameter((Object)$this$generateBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter(bitmapFuture, (String)"bitmapFuture");
        Rect rect = boundsInWindow;
        Rect rect2 = boundsInWindow;
        Bitmap bitmap = Bitmap.createBitmap((int)(rect != null ? rect.width() : $this$generateBitmap.getDecorView().getWidth()), (int)(rect2 != null ? rect2.height() : $this$generateBitmap.getDecorView().getHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n      boun\u2026ap.Config.ARGB_8888\n    )");
        Bitmap destBitmap = bitmap;
        if (Build.VERSION.SDK_INT < 26) {
            View view = $this$generateBitmap.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"decorView");
            ViewCapture.generateBitmapFromDraw(view, destBitmap, bitmapFuture, null);
        } else {
            WindowCapture.generateBitmapFromPixelCopy($this$generateBitmap, boundsInWindow, destBitmap, bitmapFuture);
        }
    }

    public static /* synthetic */ void generateBitmap$default(Window window, Rect rect, ResolvableFuture resolvableFuture, int n, Object object) {
        if ((n & 1) != 0) {
            rect = null;
        }
        WindowCapture.generateBitmap(window, rect, (ResolvableFuture<Bitmap>)resolvableFuture);
    }

    public static final void generateBitmapFromPixelCopy(@NotNull Window $this$generateBitmapFromPixelCopy, @Nullable Rect boundsInWindow, @NotNull Bitmap destBitmap, @NotNull ResolvableFuture<Bitmap> bitmapFuture) {
        Intrinsics.checkNotNullParameter((Object)$this$generateBitmapFromPixelCopy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destBitmap, (String)"destBitmap");
        Intrinsics.checkNotNullParameter(bitmapFuture, (String)"bitmapFuture");
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(bitmapFuture, destBitmap){
            final /* synthetic */ ResolvableFuture<Bitmap> $bitmapFuture;
            final /* synthetic */ Bitmap $destBitmap;
            {
                this.$bitmapFuture = $bitmapFuture;
                this.$destBitmap = $destBitmap;
            }

            public final void onPixelCopyFinished(int result) {
                if (result == 0) {
                    this.$bitmapFuture.set((Object)this.$destBitmap);
                } else {
                    String string = "PixelCopy failed: %d";
                    Object[] objectArray = new Object[]{result};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    this.$bitmapFuture.setException((Throwable)new RuntimeException(string2));
                }
            }
        };
        PixelCopy.request((Window)$this$generateBitmapFromPixelCopy, (Rect)boundsInWindow, (Bitmap)destBitmap, (PixelCopy.OnPixelCopyFinishedListener)onCopyFinished2, (Handler)new Handler(Looper.getMainLooper()));
    }

    public static /* synthetic */ void generateBitmapFromPixelCopy$default(Window window, Rect rect, Bitmap bitmap, ResolvableFuture resolvableFuture, int n, Object object) {
        if ((n & 1) != 0) {
            rect = null;
        }
        WindowCapture.generateBitmapFromPixelCopy(window, rect, bitmap, (ResolvableFuture<Bitmap>)resolvableFuture);
    }
}

