/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.os;

import android.os.Bundle;
import androidx.test.ext.truth.os.BundleSubject$$Lambda$0;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;

public final class BundleSubject
extends Subject<BundleSubject, Bundle> {
    public static BundleSubject assertThat(Bundle bundle) {
        return (BundleSubject)Truth.assertAbout(BundleSubject.bundles()).that((Object)bundle);
    }

    public static Subject.Factory<BundleSubject, Bundle> bundles() {
        return BundleSubject$$Lambda$0.$instance;
    }

    BundleSubject(FailureMetadata failureMetadata, Bundle subject) {
        super(failureMetadata, (Object)subject);
    }

    public void hasSize(int size) {
        this.check("size()", new Object[0]).that(Integer.valueOf(((Bundle)this.actual()).size())).isEqualTo((Object)size);
    }

    public void isEmpty() {
        if (!((Bundle)this.actual()).isEmpty()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be empty"), new Fact[0]);
        }
    }

    public void isNotEmpty() {
        if (((Bundle)this.actual()).isEmpty()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be non-empty"), new Fact[0]);
        }
    }

    public StringSubject string(String key) {
        return this.check("getString(%s)", new Object[]{key}).that(((Bundle)this.actual()).getString(key));
    }

    public IntegerSubject integer(String key) {
        return this.check("getInt(%s)", new Object[]{key}).that(Integer.valueOf(((Bundle)this.actual()).getInt(key)));
    }

    public void containsKey(String key) {
        if (!((Bundle)this.actual()).containsKey(key)) {
            String string = String.valueOf(key);
            this.failWithActual(Fact.simpleFact((String)(string.length() != 0 ? "expected to contain key ".concat(string) : new String("expected to contain key "))), new Fact[0]);
        }
    }

    public void doesNotContainKey(String key) {
        if (((Bundle)this.actual()).containsKey(key)) {
            String string = String.valueOf(key);
            this.failWithActual(Fact.simpleFact((String)(string.length() != 0 ? "expected to not contain key ".concat(string) : new String("expected to not contain key "))), new Fact[0]);
        }
    }
}

