/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.app;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Intent;
import android.provider.Settings;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.test.InstrumentationRegistry;
import androidx.test.annotation.Beta;
import androidx.test.core.app.ActivityScenario$$Lambda$0;
import androidx.test.core.app.InstrumentationActivityInvoker;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.platform.app.ActivityInvoker;
import androidx.test.internal.util.Checks;
import androidx.test.runner.lifecycle.ActivityLifecycleCallback;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@Beta
public final class ActivityScenario<A extends Activity> {
    private static final long TIMEOUT_MILLISECONDS = 45000L;
    private static final ActivityInvoker activityInvoker;
    private static final Map<Stage, Lifecycle.State> SUPPORTED_STAGE_TO_STATE;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<Lifecycle.State, Condition> stateToCondition = new EnumMap<Lifecycle.State, Condition>(Lifecycle.State.class);
    private final Intent startActivityIntent;
    @GuardedBy(value="lock")
    private Stage currentActivityStage;
    @GuardedBy(value="lock")
    @Nullable
    private A currentActivity;
    private final ActivityLifecycleCallback activityLifecycleObserver = new ActivityLifecycleCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onActivityLifecycleChanged(Activity activity, Stage stage) {
            if (!ActivityScenario.this.startActivityIntent.filterEquals(activity.getIntent())) {
                return;
            }
            ActivityScenario.this.lock.lock();
            try {
                ActivityScenario.this.currentActivityStage = stage;
                ActivityScenario.this.currentActivity = (Activity)(stage != Stage.DESTROYED ? activity : null);
                Lifecycle.State currentState = (Lifecycle.State)((Object)SUPPORTED_STAGE_TO_STATE.get((Object)stage));
                if (currentState != null) {
                    ((Condition)ActivityScenario.this.stateToCondition.get((Object)currentState)).signal();
                }
            }
            finally {
                ActivityScenario.this.lock.unlock();
            }
        }
    };

    private ActivityScenario(Class<A> activityClass) {
        Checks.checkState(Settings.System.getInt((ContentResolver)InstrumentationRegistry.getInstrumentation().getTargetContext().getContentResolver(), (String)"always_finish_activities", (int)0) == 0, "\"Don't keep activities\" developer options must be disabled for ActivityScenario");
        this.stateToCondition.put(Lifecycle.State.CREATED, this.lock.newCondition());
        this.stateToCondition.put(Lifecycle.State.STARTED, this.lock.newCondition());
        this.stateToCondition.put(Lifecycle.State.RESUMED, this.lock.newCondition());
        this.startActivityIntent = activityInvoker.getIntentForActivity(activityClass);
        this.currentActivityStage = Stage.PRE_ON_CREATE;
    }

    public static <A extends Activity> ActivityScenario<A> launch(Class<A> activityClass) {
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityScenario<A> scenario = new ActivityScenario<A>(activityClass);
        ActivityLifecycleMonitorRegistry.getInstance().addLifecycleCallback(scenario.activityLifecycleObserver);
        activityInvoker.startActivity(scenario.startActivityIntent);
        super.waitForActivityToBecome(Lifecycle.State.RESUMED);
        return scenario;
    }

    private void waitForActivityToBecome(Lifecycle.State state) {
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        this.lock.lock();
        try {
            if (state == SUPPORTED_STAGE_TO_STATE.get((Object)this.currentActivityStage)) {
                return;
            }
            long now = System.currentTimeMillis();
            long deadline = now + 45000L;
            while (now < deadline && state != SUPPORTED_STAGE_TO_STATE.get((Object)this.currentActivityStage)) {
                this.stateToCondition.get((Object)state).await(deadline - now, TimeUnit.MILLISECONDS);
                now = System.currentTimeMillis();
            }
            if (state != SUPPORTED_STAGE_TO_STATE.get((Object)this.currentActivityStage)) {
                throw new AssertionError((Object)String.format("Activity never becomes requested state \"%s\" (last lifecycle transition = \"%s\")", new Object[]{state, this.currentActivityStage}));
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)String.format("Activity never becomes requested state \"%s\" (last lifecycle transition = \"%s\")", new Object[]{state, this.currentActivityStage}));
        }
        finally {
            this.lock.unlock();
        }
    }

    private ActivityState<A> getCurrentActivityState() {
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        this.lock.lock();
        try {
            ActivityState<A> activityState = new ActivityState<A>(this.currentActivity, SUPPORTED_STAGE_TO_STATE.get((Object)this.currentActivityStage));
            return activityState;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ActivityScenario<A> moveToState(Lifecycle.State newState) {
        Checks.checkNotMainThread();
        Checks.checkArgument(this.stateToCondition.containsKey((Object)newState), String.format("A requested state \"%s\" is not supported", new Object[]{newState}));
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityState<A> currentState = this.getCurrentActivityState();
        Checks.checkNotNull(currentState.state);
        if (currentState.state == newState) {
            return this;
        }
        Checks.checkState(currentState.state != Lifecycle.State.DESTROYED && currentState.activity != null, String.format("Cannot move to state \"%s\" since the Activity has been destroyed already", new Object[]{newState}));
        switch (newState) {
            case CREATED: {
                activityInvoker.stopActivity((Activity)currentState.activity);
                break;
            }
            case STARTED: {
                this.moveToState(Lifecycle.State.RESUMED);
                activityInvoker.pauseActivity((Activity)currentState.activity);
                break;
            }
            case RESUMED: {
                activityInvoker.resumeActivity((Activity)currentState.activity);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("A requested state \"%s\" is not supported", new Object[]{newState}));
            }
        }
        this.waitForActivityToBecome(newState);
        return this;
    }

    public ActivityScenario<A> recreate() {
        ActivityState<A> activityState;
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityState<A> prevActivityState = this.getCurrentActivityState();
        Checks.checkNotNull(prevActivityState.activity);
        Checks.checkNotNull(prevActivityState.state);
        this.moveToState(Lifecycle.State.RESUMED);
        activityInvoker.recreateActivity((Activity)prevActivityState.activity);
        long now = System.currentTimeMillis();
        long deadline = now + 45000L;
        do {
            this.waitForActivityToBecome(Lifecycle.State.RESUMED);
            now = System.currentTimeMillis();
            activityState = this.getCurrentActivityState();
        } while (now < deadline && activityState.activity == prevActivityState.activity);
        if (activityState.activity == prevActivityState.activity) {
            throw new IllegalStateException("Requested a re-creation of Activity but didn't happen");
        }
        this.moveToState(prevActivityState.state);
        return this;
    }

    public ActivityScenario<A> onActivity(ActivityAction<A> action) {
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new ActivityScenario$$Lambda$0(this, action));
        return this;
    }

    final /* synthetic */ void lambda$onActivity$0$ActivityScenario(ActivityAction action) {
        this.lock.lock();
        try {
            Checks.checkNotNull(this.currentActivity, "Cannot run onActivity since Activity has been destroyed already");
            action.perform(this.currentActivity);
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        List<ActivityInvoker> impls = ServiceLoaderWrapper.loadService(ActivityInvoker.class);
        if (impls.isEmpty()) {
            activityInvoker = new InstrumentationActivityInvoker();
        } else if (impls.size() == 1) {
            activityInvoker = impls.get(0);
        } else {
            throw new IllegalStateException(String.format("Found more than one %s implementations.", ActivityInvoker.class.getName()));
        }
        SUPPORTED_STAGE_TO_STATE = new EnumMap<Stage, Lifecycle.State>(Stage.class);
        SUPPORTED_STAGE_TO_STATE.put(Stage.RESUMED, Lifecycle.State.RESUMED);
        SUPPORTED_STAGE_TO_STATE.put(Stage.PAUSED, Lifecycle.State.STARTED);
        SUPPORTED_STAGE_TO_STATE.put(Stage.STOPPED, Lifecycle.State.CREATED);
    }

    public static interface ActivityAction<A extends Activity> {
        public void perform(A var1);
    }

    private static class ActivityState<A extends Activity> {
        @Nullable
        final A activity;
        @Nullable
        final Lifecycle.State state;

        ActivityState(@Nullable A activity, @Nullable Lifecycle.State state) {
            this.activity = activity;
            this.state = state;
        }
    }
}

