/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.location;

import android.location.Location;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.test.ext.truth.location.LocationSubject$$Lambda$0;
import androidx.test.ext.truth.os.BundleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;

public class LocationSubject
extends Subject {
    private final Location actual;

    public static LocationSubject assertThat(Location location) {
        return (LocationSubject)Truth.assertAbout(LocationSubject.locations()).that((Object)location);
    }

    public static Subject.Factory<LocationSubject, Location> locations() {
        return LocationSubject$$Lambda$0.$instance;
    }

    private LocationSubject(FailureMetadata failureMetadata, @Nullable Location subject) {
        super(failureMetadata, (Object)subject);
        this.actual = subject;
    }

    public void isEqualTo(@Nullable Object other) {
        if (other instanceof Location) {
            this.isEqualTo((Location)other);
            return;
        }
        super.isEqualTo(other);
    }

    public void isEqualTo(@Nullable Location other) {
        if (this.actual == null || other == null) {
            super.isEqualTo((Object)other);
            return;
        }
        this.check("getProvider()", new Object[0]).that(this.actual.getProvider()).isEqualTo((Object)other.getProvider());
        this.check("getTime()", new Object[0]).that(Long.valueOf(this.actual.getTime())).isEqualTo((Object)other.getTime());
        if (Build.VERSION.SDK_INT >= 17) {
            this.check("getElapsedRealtimeNanos()", new Object[0]).that(Long.valueOf(this.actual.getElapsedRealtimeNanos())).isEqualTo((Object)other.getElapsedRealtimeNanos());
        }
        this.check("getLatitude()", new Object[0]).that(Double.valueOf(this.actual.getLatitude())).isEqualTo((Object)other.getLatitude());
        this.check("getLongitude()", new Object[0]).that(Double.valueOf(this.actual.getLongitude())).isEqualTo((Object)other.getLongitude());
        this.check("getAltitude()", new Object[0]).that(Double.valueOf(this.actual.getAltitude())).isEqualTo((Object)other.getAltitude());
        this.check("getSpeed()", new Object[0]).that(Float.valueOf(this.actual.getSpeed())).isEqualTo((Object)Float.valueOf(other.getSpeed()));
        this.check("getBearing()", new Object[0]).that(Float.valueOf(this.actual.getBearing())).isEqualTo((Object)Float.valueOf(other.getBearing()));
        this.check("getAccuracy()", new Object[0]).that(Float.valueOf(this.actual.getAccuracy())).isEqualTo((Object)Float.valueOf(other.getAccuracy()));
        if (Build.VERSION.SDK_INT >= 26) {
            this.check("getVerticalAccuracyMeters()", new Object[0]).that(Float.valueOf(this.actual.getVerticalAccuracyMeters())).isEqualTo((Object)Float.valueOf(other.getVerticalAccuracyMeters()));
            this.check("getSpeedAccuracyMetersPerSecond()", new Object[0]).that(Float.valueOf(this.actual.getSpeedAccuracyMetersPerSecond())).isEqualTo((Object)Float.valueOf(other.getSpeedAccuracyMetersPerSecond()));
            this.check("getBearingAccuracyDegrees()", new Object[0]).that(Float.valueOf(this.actual.getBearingAccuracyDegrees())).isEqualTo((Object)Float.valueOf(other.getBearingAccuracyDegrees()));
        }
    }

    public void isAt(Location other) {
        this.check("getLatitude()", new Object[0]).that(Double.valueOf(this.actual.getLatitude())).isEqualTo((Object)other.getLatitude());
        this.check("getLongitude()", new Object[0]).that(Double.valueOf(this.actual.getLongitude())).isEqualTo((Object)other.getLongitude());
    }

    public void isNearby(Location other, float distanceM) {
        this.check("distanceTo()", new Object[0]).that(Float.valueOf(this.actual.distanceTo(other))).isAtMost((Comparable)Float.valueOf(distanceM));
    }

    public void isFaraway(Location other, float distanceM) {
        this.check("distanceTo()", new Object[0]).that(Float.valueOf(this.actual.distanceTo(other))).isAtLeast((Comparable)Float.valueOf(distanceM));
    }

    public void hasAltitude() {
        this.check("hasAltitude()", new Object[0]).that(Boolean.valueOf(this.actual.hasAltitude())).isTrue();
    }

    public void hasSpeed() {
        this.check("hasSpeed()", new Object[0]).that(Boolean.valueOf(this.actual.hasSpeed())).isTrue();
    }

    public void hasBearing() {
        this.check("hasBearing()", new Object[0]).that(Boolean.valueOf(this.actual.hasBearing())).isTrue();
    }

    public void hasAccuracy() {
        this.check("hasAccuracy()", new Object[0]).that(Boolean.valueOf(this.actual.hasAccuracy())).isTrue();
    }

    public void isMock() {
        this.check("isFromMockProvider()", new Object[0]).that(Boolean.valueOf(this.actual.isFromMockProvider())).isTrue();
    }

    public void isNotMock() {
        this.check("isFromMockProvider()", new Object[0]).that(Boolean.valueOf(this.actual.isFromMockProvider())).isFalse();
    }

    public final BundleSubject extras() {
        return (BundleSubject)this.check("getExtras()", new Object[0]).about(BundleSubject.bundles()).that((Object)this.actual.getExtras());
    }

    static final /* bridge */ /* synthetic */ LocationSubject bridge$lambda$0$LocationSubject(FailureMetadata failureMetadata, Location location) {
        return new LocationSubject(failureMetadata, location);
    }
}

