/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.content;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import androidx.test.ext.truth.content.IntentSubject$$Lambda$0;
import androidx.test.ext.truth.internal.FlagUtil;
import androidx.test.ext.truth.os.BundleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.util.List;

public final class IntentSubject
extends Subject {
    private final Intent actual;

    public static IntentSubject assertThat(Intent intent) {
        return (IntentSubject)Truth.assertAbout(IntentSubject.intents()).that((Object)intent);
    }

    public static Subject.Factory<IntentSubject, Intent> intents() {
        return IntentSubject$$Lambda$0.$instance;
    }

    private IntentSubject(FailureMetadata failureMetadata, Intent subject) {
        super(failureMetadata, (Object)subject);
        this.actual = subject;
    }

    public final void hasComponentClass(Class<?> componentClass) {
        this.hasComponentClass(componentClass.getName());
    }

    public final void hasComponent(String packageName, String className) {
        this.hasComponentPackage(packageName);
        this.hasComponentClass(className);
    }

    public final void hasComponent(ComponentName component) {
        this.hasComponent(component.getPackageName(), component.getClassName());
    }

    public final void hasComponentClass(String className) {
        this.check("getComponent().getClassName()", new Object[0]).that(this.actual.getComponent().getClassName()).isEqualTo((Object)className);
    }

    public final void hasComponentPackage(String packageName) {
        this.check("getComponent().getPackageName()", new Object[0]).that(this.actual.getComponent().getPackageName()).isEqualTo((Object)packageName);
    }

    public final void hasPackage(String packageName) {
        this.check("getPackage()", new Object[0]).that(this.actual.getPackage()).isEqualTo((Object)packageName);
    }

    public final void hasAction(String action) {
        this.check("getAction()", new Object[0]).that(this.actual.getAction()).isEqualTo((Object)action);
    }

    public final void hasNoAction() {
        this.hasAction(null);
    }

    public final void hasData(Uri uri) {
        this.check("getData()", new Object[0]).that((Comparable)this.actual.getData()).isEqualTo((Object)uri);
    }

    public final void hasType(String type) {
        this.check("getType()", new Object[0]).that(this.actual.getType()).isEqualTo((Object)type);
    }

    public final BundleSubject extras() {
        return (BundleSubject)this.check("getExtras()", new Object[0]).about(BundleSubject.bundles()).that((Object)this.actual.getExtras());
    }

    public final IterableSubject categories() {
        return this.check("getCategories()", new Object[0]).that((Iterable)this.actual.getCategories());
    }

    public final void hasFlags(int flag) {
        List<String> actualFlags = FlagUtil.flagNames(this.actual.getFlags());
        List<String> expectedFlags = FlagUtil.flagNames(flag);
        this.check("getFlags()", new Object[0]).that(actualFlags).containsAtLeastElementsIn(expectedFlags);
    }

    public final void filtersEquallyTo(Intent intent) {
        if (!this.actual.filterEquals(intent)) {
            this.failWithActual("expected to be equal for intent filters to", intent);
        }
    }

    static final /* bridge */ /* synthetic */ IntentSubject bridge$lambda$0$IntentSubject(FailureMetadata failureMetadata, Intent intent) {
        return new IntentSubject(failureMetadata, intent);
    }
}

