/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.location;

import android.location.Location;
import android.os.Build;
import androidx.test.ext.truth.location.LocationCorrespondences$$ExternalSyntheticLambda0;
import androidx.test.ext.truth.location.LocationCorrespondences$$ExternalSyntheticLambda1;
import androidx.test.ext.truth.location.LocationCorrespondences$$ExternalSyntheticLambda2;
import com.google.common.base.Objects;
import com.google.common.truth.Correspondence;

public final class LocationCorrespondences {
    public static Correspondence<Location, Location> at() {
        return Correspondence.from((Correspondence.BinaryPredicate)LocationCorrespondences$$ExternalSyntheticLambda1.INSTANCE, (String)"has lat/lon at");
    }

    public static Correspondence<Location, Location> equality() {
        return Correspondence.from((Correspondence.BinaryPredicate)LocationCorrespondences$$ExternalSyntheticLambda2.INSTANCE, (String)"is equal to");
    }

    public static Correspondence<Location, Location> nearby(float distanceM) {
        float f = distanceM;
        return Correspondence.from((Correspondence.BinaryPredicate)new LocationCorrespondences$$ExternalSyntheticLambda0(f), (String)"has lat/lon near");
    }

    private LocationCorrespondences() {
    }

    static /* synthetic */ boolean lambda$at$1(Location actual, Location expected) {
        return actual.getLatitude() == expected.getLatitude() && actual.getLongitude() == expected.getLongitude();
    }

    static /* synthetic */ boolean lambda$equality$0(Location actual, Location expected) {
        if (Build.VERSION.SDK_INT >= 31) {
            return Objects.equal((Object)actual, (Object)expected);
        }
        if (actual == expected) {
            return true;
        }
        if (actual == null || expected == null) {
            return false;
        }
        if (!Objects.equal((Object)actual.getProvider(), (Object)expected.getProvider())) {
            return false;
        }
        if (actual.getTime() != expected.getTime()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17 && actual.getElapsedRealtimeNanos() != expected.getElapsedRealtimeNanos()) {
            return false;
        }
        if (actual.getLatitude() != expected.getLatitude()) {
            return false;
        }
        if (actual.getLongitude() != expected.getLongitude()) {
            return false;
        }
        if (actual.getAltitude() != expected.getAltitude()) {
            return false;
        }
        if (actual.getSpeed() != expected.getSpeed()) {
            return false;
        }
        if (actual.getBearing() != expected.getBearing()) {
            return false;
        }
        if (actual.getAccuracy() != expected.getAccuracy()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (actual.getVerticalAccuracyMeters() != expected.getVerticalAccuracyMeters()) {
                return false;
            }
            if (actual.getSpeedAccuracyMetersPerSecond() != expected.getSpeedAccuracyMetersPerSecond()) {
                return false;
            }
            if (actual.getBearingAccuracyDegrees() != expected.getBearingAccuracyDegrees()) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ boolean lambda$nearby$2(float distanceM, Location actual, Location expected) {
        return actual.distanceTo(expected) <= distanceM;
    }
}

