/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.util;

import android.util.SparseBooleanArray;
import com.google.common.truth.ExpectFailure;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;

public final class SparseBooleanArraySubject
extends Subject {
    private final SparseBooleanArray actual;

    private static Subject.Factory<SparseBooleanArraySubject, SparseBooleanArray> sparseBooleanArrays() {
        return SparseBooleanArraySubject::new;
    }

    SparseBooleanArraySubject(FailureMetadata failureMetadata, SparseBooleanArray subject) {
        super(failureMetadata, (Object)subject);
        this.actual = subject;
    }

    public void hasTrueValueAt(int key) {
        this.check("value for key <%s> expected to be true but was not", new Object[]{key}).that(Boolean.valueOf(this.actual.get(key))).isTrue();
    }

    public void hasFalseValueAt(int key) {
        if (this.actual.indexOfKey(key) == -1) {
            this.failWithoutActual(Fact.fact((String)"key <%s> expected to be present but was not", (Object)key), new Fact[0]);
        }
        this.check("value for key <%s> expected to be false but was not", new Object[]{key}).that(Boolean.valueOf(this.actual.get(key))).isFalse();
    }

    public void containsKey(int key) {
        this.check("key <%s> expected to be present but was not.", new Object[]{key}).that(Integer.valueOf(this.actual.indexOfKey(key))).isGreaterThan((Comparable)Integer.valueOf(-1));
    }

    public void doesNotContainKey(int key) {
        this.check("key <%s> expected to not be present but was.", new Object[]{key}).that(Integer.valueOf(this.actual.indexOfKey(key))).isLessThan((Comparable)Integer.valueOf(0));
    }

    public void hasSize(int size) {
        this.check("size()", new Object[0]).that(Integer.valueOf(this.actual.size())).isEqualTo((Object)size);
    }

    public void isEmpty() {
        this.check(" expected to be empty but was not", new Object[0]).that(Boolean.valueOf(this.actual.size() == 0)).isTrue();
    }

    public void isNotEmpty() {
        this.check(" expected not to be empty but it was", new Object[0]).that(Boolean.valueOf(this.actual.size() == 0)).isFalse();
    }

    public static SparseBooleanArraySubject assertThat(SparseBooleanArray actual) {
        return (SparseBooleanArraySubject)Truth.assertAbout(SparseBooleanArraySubject.sparseBooleanArrays()).that((Object)actual);
    }

    public static AssertionError expectFailure(ExpectFailure.SimpleSubjectBuilderCallback<SparseBooleanArraySubject, SparseBooleanArray> callback) {
        return ExpectFailure.expectFailureAbout(SparseBooleanArraySubject.sparseBooleanArrays(), callback);
    }
}

