/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.location;

import android.location.Location;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.test.ext.truth.os.BundleSubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.util.concurrent.TimeUnit;

public class LocationSubject
extends Subject {
    private final Location actual;

    public static LocationSubject assertThat(Location location) {
        return (LocationSubject)Truth.assertAbout(LocationSubject.locations()).that((Object)location);
    }

    public static Subject.Factory<LocationSubject, Location> locations() {
        return LocationSubject::new;
    }

    private LocationSubject(FailureMetadata failureMetadata, Location subject) {
        super(failureMetadata, (Object)subject);
        this.actual = subject;
    }

    public void isEqualTo(@Nullable Object otherObj) {
        if (Build.VERSION.SDK_INT >= 31) {
            super.isEqualTo(otherObj);
            return;
        }
        if (this.actual == null || !(otherObj instanceof Location)) {
            super.isEqualTo(otherObj);
            return;
        }
        Location other = (Location)otherObj;
        this.check("getProvider()", new Object[0]).that(this.actual.getProvider()).isEqualTo((Object)other.getProvider());
        this.check("getTime()", new Object[0]).that(Long.valueOf(this.actual.getTime())).isEqualTo((Object)other.getTime());
        this.check("getElapsedRealtimeNanos()", new Object[0]).that(Long.valueOf(this.actual.getElapsedRealtimeNanos())).isEqualTo((Object)other.getElapsedRealtimeNanos());
        this.check("getLatitude()", new Object[0]).that(Double.valueOf(this.actual.getLatitude())).isEqualTo((Object)other.getLatitude());
        this.check("getLongitude()", new Object[0]).that(Double.valueOf(this.actual.getLongitude())).isEqualTo((Object)other.getLongitude());
        this.check("getAltitude()", new Object[0]).that(Double.valueOf(this.actual.getAltitude())).isEqualTo((Object)other.getAltitude());
        this.check("getSpeed()", new Object[0]).that(Float.valueOf(this.actual.getSpeed())).isEqualTo((Object)Float.valueOf(other.getSpeed()));
        this.check("getBearing()", new Object[0]).that(Float.valueOf(this.actual.getBearing())).isEqualTo((Object)Float.valueOf(other.getBearing()));
        this.check("getAccuracy()", new Object[0]).that(Float.valueOf(this.actual.getAccuracy())).isEqualTo((Object)Float.valueOf(other.getAccuracy()));
        if (Build.VERSION.SDK_INT >= 26) {
            this.check("getVerticalAccuracyMeters()", new Object[0]).that(Float.valueOf(this.actual.getVerticalAccuracyMeters())).isEqualTo((Object)Float.valueOf(other.getVerticalAccuracyMeters()));
            this.check("getSpeedAccuracyMetersPerSecond()", new Object[0]).that(Float.valueOf(this.actual.getSpeedAccuracyMetersPerSecond())).isEqualTo((Object)Float.valueOf(other.getSpeedAccuracyMetersPerSecond()));
            this.check("getBearingAccuracyDegrees()", new Object[0]).that(Float.valueOf(this.actual.getBearingAccuracyDegrees())).isEqualTo((Object)Float.valueOf(other.getBearingAccuracyDegrees()));
        }
    }

    public void isAt(Location other) {
        this.isAt(other.getLatitude(), other.getLongitude());
    }

    public void isAt(double latitude, double longitude) {
        this.check("getLatitude()", new Object[0]).that(Double.valueOf(this.actual.getLatitude())).isEqualTo((Object)latitude);
        this.check("getLongitude()", new Object[0]).that(Double.valueOf(this.actual.getLongitude())).isEqualTo((Object)longitude);
    }

    public void isNotAt(Location other) {
        this.isNotAt(other.getLatitude(), other.getLongitude());
    }

    public void isNotAt(double latitude, double longitude) {
        this.check("getLatitude()", new Object[0]).that(Double.valueOf(this.actual.getLatitude())).isNotEqualTo((Object)latitude);
        this.check("getLongitude()", new Object[0]).that(Double.valueOf(this.actual.getLongitude())).isNotEqualTo((Object)longitude);
    }

    public FloatSubject distanceTo(double latitude, double longitude) {
        Location location = new Location("");
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        return this.distanceTo(location);
    }

    public FloatSubject distanceTo(Location location) {
        return this.check("distanceTo(" + location.getLatitude() + ", " + location.getLongitude() + ")", new Object[0]).that(Float.valueOf(this.actual.distanceTo(location)));
    }

    public void isNearby(Location other, float distanceM) {
        this.distanceTo(other).isAtMost((Comparable)Float.valueOf(distanceM));
    }

    public void isFaraway(Location other, float distanceM) {
        this.distanceTo(other).isAtLeast((Comparable)Float.valueOf(distanceM));
    }

    public FloatSubject bearingTo(double latitude, double longitude) {
        Location location = new Location("");
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        return this.bearingTo(location);
    }

    public FloatSubject bearingTo(Location location) {
        return this.check("bearingTo(" + location.getLatitude() + ", " + location.getLongitude() + ")", new Object[0]).that(Float.valueOf(this.actual.bearingTo(location)));
    }

    public LongSubject time() {
        return this.check("getTime()", new Object[0]).that(Long.valueOf(this.actual.getTime()));
    }

    public LongSubject elapsedRealtimeNanos() {
        return this.check("getElapsedRealtimeNanos()", new Object[0]).that(Long.valueOf(this.actual.getElapsedRealtimeNanos()));
    }

    public LongSubject elapsedRealtimeMillis() {
        return this.check("getElapsedRealtimeMillis()", new Object[0]).that(Long.valueOf(TimeUnit.NANOSECONDS.toMillis(this.actual.getElapsedRealtimeNanos())));
    }

    public void hasProvider(String provider) {
        this.check("getProvider()", new Object[0]).that(this.actual.getProvider()).isEqualTo((Object)provider);
    }

    public void doesNotHaveProvider(String provider) {
        this.check("getProvider()", new Object[0]).that(this.actual.getProvider()).isNotEqualTo((Object)provider);
    }

    public void hasAltitude() {
        this.check("hasAltitude()", new Object[0]).that(Boolean.valueOf(this.actual.hasAltitude())).isTrue();
    }

    public DoubleSubject altitude() {
        return this.check("getAltitude()", new Object[0]).that(Double.valueOf(this.actual.getAltitude()));
    }

    public void hasSpeed() {
        this.check("hasSpeed()", new Object[0]).that(Boolean.valueOf(this.actual.hasSpeed())).isTrue();
    }

    public FloatSubject speed() {
        return this.check("getSpeed()", new Object[0]).that(Float.valueOf(this.actual.getSpeed()));
    }

    public void hasSpeedAccuracy() {
        this.check("hasSpeedAccuracy()", new Object[0]).that(Boolean.valueOf(this.actual.hasSpeedAccuracy())).isTrue();
    }

    public FloatSubject speedAccuracy() {
        return this.check("getSpeedAccuracyMetersPerSecond()", new Object[0]).that(Float.valueOf(this.actual.getSpeedAccuracyMetersPerSecond()));
    }

    public void hasBearing() {
        this.check("hasBearing()", new Object[0]).that(Boolean.valueOf(this.actual.hasBearing())).isTrue();
    }

    public FloatSubject bearing() {
        return this.check("getBearing()", new Object[0]).that(Float.valueOf(this.actual.getBearing()));
    }

    public void hasBearingAccuracy() {
        this.check("hasBearingAccuracy()", new Object[0]).that(Boolean.valueOf(this.actual.hasBearingAccuracy())).isTrue();
    }

    public FloatSubject bearingAccuracy() {
        return this.check("getBearingAccuracyDegrees()", new Object[0]).that(Float.valueOf(this.actual.getBearingAccuracyDegrees()));
    }

    public void hasAccuracy() {
        this.check("hasAccuracy()", new Object[0]).that(Boolean.valueOf(this.actual.hasAccuracy())).isTrue();
    }

    public FloatSubject accuracy() {
        return this.check("getAccuracy()", new Object[0]).that(Float.valueOf(this.actual.getAccuracy()));
    }

    public void hasVerticalAccuracy() {
        this.check("hasVerticalAccuracy()", new Object[0]).that(Boolean.valueOf(this.actual.hasVerticalAccuracy())).isTrue();
    }

    public FloatSubject verticalAccuracy() {
        return this.check("getVerticalAccuracyMeters()", new Object[0]).that(Float.valueOf(this.actual.getVerticalAccuracyMeters()));
    }

    public void isMock() {
        this.check("isFromMockProvider()", new Object[0]).that(Boolean.valueOf(this.actual.isFromMockProvider())).isTrue();
    }

    public void isNotMock() {
        this.check("isFromMockProvider()", new Object[0]).that(Boolean.valueOf(this.actual.isFromMockProvider())).isFalse();
    }

    public final BundleSubject extras() {
        return (BundleSubject)this.check("getExtras()", new Object[0]).about(BundleSubject.bundles()).that((Object)this.actual.getExtras());
    }
}

