/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.location;

import android.location.Location;
import android.os.Build;
import com.google.common.base.Objects;
import com.google.common.truth.Correspondence;

public final class LocationCorrespondences {
    public static Correspondence<Location, Location> equality() {
        return Correspondence.from((actual, expected) -> {
            if (Build.VERSION.SDK_INT >= 31) {
                return Objects.equal((Object)actual, (Object)expected);
            }
            if (actual == expected) {
                return true;
            }
            if (actual == null || expected == null) {
                return false;
            }
            if (!Objects.equal((Object)actual.getProvider(), (Object)expected.getProvider())) {
                return false;
            }
            if (actual.getTime() != expected.getTime()) {
                return false;
            }
            if (actual.getElapsedRealtimeNanos() != expected.getElapsedRealtimeNanos()) {
                return false;
            }
            if (actual.getLatitude() != expected.getLatitude()) {
                return false;
            }
            if (actual.getLongitude() != expected.getLongitude()) {
                return false;
            }
            if (actual.getAltitude() != expected.getAltitude()) {
                return false;
            }
            if (actual.getSpeed() != expected.getSpeed()) {
                return false;
            }
            if (actual.getBearing() != expected.getBearing()) {
                return false;
            }
            if (actual.getAccuracy() != expected.getAccuracy()) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                if (actual.getVerticalAccuracyMeters() != expected.getVerticalAccuracyMeters()) {
                    return false;
                }
                if (actual.getSpeedAccuracyMetersPerSecond() != expected.getSpeedAccuracyMetersPerSecond()) {
                    return false;
                }
                if (actual.getBearingAccuracyDegrees() != expected.getBearingAccuracyDegrees()) {
                    return false;
                }
            }
            return true;
        }, (String)"is equal to");
    }

    public static Correspondence<Location, Location> at() {
        return Correspondence.from((actual, expected) -> actual.getLatitude() == expected.getLatitude() && actual.getLongitude() == expected.getLongitude(), (String)"has lat/lon at");
    }

    public static Correspondence<Location, Location> nearby(float distanceM) {
        return Correspondence.from((actual, expected) -> actual.distanceTo(expected) <= distanceM, (String)"has lat/lon near");
    }

    private LocationCorrespondences() {
    }
}

