/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.annotation.Beta;
import androidx.test.internal.util.Checks;
import java.util.Properties;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Beta
public class PortForwardingRule
implements TestRule {
    private static final String TAG = "PortForwardingRule";
    public static final int MIN_PORT = 1024;
    public static final int MAX_PORT = 65535;
    @VisibleForTesting
    static final int DEFAULT_PROXY_PORT = 8080;
    @VisibleForTesting
    static final String DEFAULT_PROXY_HOST = "127.0.0.1";
    @VisibleForTesting
    static final String HTTP_HOST_PROPERTY = "http.proxyHost";
    @VisibleForTesting
    static final String HTTPS_HOST_PROPERTY = "https.proxyHost";
    @VisibleForTesting
    static final String HTTP_PORT_PROPERTY = "http.proxyPort";
    @VisibleForTesting
    static final String HTTPS_PORT_PROPERTY = "https.proxyPort";
    @VisibleForTesting
    final String mProxyHost;
    @VisibleForTesting
    final int mProxyPort;
    @VisibleForTesting
    Properties mProp;
    private Properties mBackUpProp;

    private PortForwardingRule(Builder builder) {
        this(builder.mProxyHost, builder.mProxyPort, builder.mProp);
    }

    protected PortForwardingRule(int proxyPort) {
        this(DEFAULT_PROXY_HOST, proxyPort, System.getProperties());
    }

    @VisibleForTesting
    PortForwardingRule(String proxyHost, int proxyPort, @NonNull Properties properties) {
        this.mProxyHost = proxyHost;
        this.mProxyPort = proxyPort;
        this.mProp = (Properties)Checks.checkNotNull((Object)properties);
        this.mBackUpProp = new Properties();
        this.backUpProperties();
    }

    protected static int getDefaultPort() {
        return 8080;
    }

    protected void beforePortForwarding() {
    }

    protected void afterPortForwarding() {
    }

    protected void beforeRestoreForwarding() {
    }

    protected void afterRestoreForwarding() {
    }

    private void setPortForwarding() {
        this.beforePortForwarding();
        this.mProp.setProperty(HTTP_HOST_PROPERTY, this.mProxyHost);
        this.mProp.setProperty(HTTPS_HOST_PROPERTY, this.mProxyHost);
        this.mProp.setProperty(HTTP_PORT_PROPERTY, String.valueOf(this.mProxyPort));
        this.mProp.setProperty(HTTPS_PORT_PROPERTY, String.valueOf(this.mProxyPort));
        this.afterPortForwarding();
    }

    private void restorePortForwarding() {
        try {
            this.beforeRestoreForwarding();
        }
        finally {
            this.restoreOneProperty(this.mProp, this.mBackUpProp, HTTP_HOST_PROPERTY);
            this.restoreOneProperty(this.mProp, this.mBackUpProp, HTTPS_HOST_PROPERTY);
            this.restoreOneProperty(this.mProp, this.mBackUpProp, HTTP_PORT_PROPERTY);
            this.restoreOneProperty(this.mProp, this.mBackUpProp, HTTPS_PORT_PROPERTY);
            this.afterRestoreForwarding();
        }
    }

    private void backUpProperties() {
        if (this.mProp.getProperty(HTTP_HOST_PROPERTY) != null) {
            this.mBackUpProp.setProperty(HTTP_HOST_PROPERTY, this.mProp.getProperty(HTTP_HOST_PROPERTY));
        }
        if (this.mProp.getProperty(HTTPS_HOST_PROPERTY) != null) {
            this.mBackUpProp.setProperty(HTTPS_HOST_PROPERTY, this.mProp.getProperty(HTTPS_HOST_PROPERTY));
        }
        if (this.mProp.getProperty(HTTP_PORT_PROPERTY) != null) {
            this.mBackUpProp.setProperty(HTTP_PORT_PROPERTY, this.mProp.getProperty(HTTP_PORT_PROPERTY));
        }
        if (this.mProp.getProperty(HTTPS_PORT_PROPERTY) != null) {
            this.mBackUpProp.setProperty(HTTPS_PORT_PROPERTY, this.mProp.getProperty(HTTPS_PORT_PROPERTY));
        }
    }

    private void restoreOneProperty(Properties prop, Properties backUpProp, String key) {
        if (backUpProp.getProperty(key) != null) {
            prop.setProperty(key, backUpProp.getProperty(key));
        } else {
            prop.remove(key);
        }
    }

    public Statement apply(Statement base, Description description) {
        return new PortForwardingStatement(base);
    }

    private class PortForwardingStatement
    extends Statement {
        private final Statement mBase;

        public PortForwardingStatement(Statement base) {
            this.mBase = base;
        }

        public void evaluate() throws Throwable {
            try {
                PortForwardingRule.this.setPortForwarding();
                Log.i((String)PortForwardingRule.TAG, (String)String.format("The current process traffic is forwarded to %s:%d", PortForwardingRule.this.mProxyHost, PortForwardingRule.this.mProxyPort));
                this.mBase.evaluate();
            }
            finally {
                PortForwardingRule.this.restorePortForwarding();
                Log.i((String)PortForwardingRule.TAG, (String)"Current process traffic forwarding is cancelled");
            }
        }
    }

    public static class Builder {
        private String mProxyHost = "127.0.0.1";
        private int mProxyPort = 8080;
        private Properties mProp = System.getProperties();

        public Builder withProxyHost(@NonNull String proxyHost) {
            this.mProxyHost = (String)Checks.checkNotNull((Object)proxyHost);
            return this;
        }

        public Builder withProxyPort(int proxyPort) {
            Checks.checkArgument((proxyPort >= 1024 && proxyPort <= 65535 ? 1 : 0) != 0, (String)"%d is used as a proxy port, must in range [%d, %d]", (Object[])new Object[]{proxyPort, 1024, 65535});
            this.mProxyPort = proxyPort;
            return this;
        }

        public Builder withProperties(@NonNull Properties properties) {
            this.mProp = (Properties)Checks.checkNotNull((Object)properties);
            return this;
        }

        public PortForwardingRule build() {
            return new PortForwardingRule(this);
        }
    }
}

