/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule.logging;

import android.app.Instrumentation;
import android.app.UiAutomation;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.test.annotation.Beta;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Beta
public class AtraceLogger {
    private static final String ATRACE_START = "atrace --async_start -b %d -c %s";
    private static final String ATRACE_DUMP = "atrace --async_dump -b %d -z %s";
    private static final String ATRACE_STOP = "atrace --async_stop -b %d -z %s";
    private static final String ATRACEHELPER_TAG = "AtraceLogger";
    private static final String CATEGORY_SEPARATOR = " ";
    private static final int BUFFER_SIZE = 8192;
    private static volatile AtraceLogger mLoggerInstance;
    private UiAutomation mUiAutomation;
    private String mTraceFileName;
    private List<ByteArrayOutputStream> mAtraceDataList;
    private Thread mDumpThread;
    private File mDestAtraceDirectory;
    private boolean mAtraceRunning = false;
    private IOException mDumpIOException;

    private AtraceLogger(Instrumentation instrumentation) {
        this.mUiAutomation = instrumentation.getUiAutomation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtraceLogger getAtraceLoggerInstance(Instrumentation instrumentation) {
        if (mLoggerInstance != null) return mLoggerInstance;
        Class<AtraceLogger> clazz = AtraceLogger.class;
        synchronized (AtraceLogger.class) {
            if (mLoggerInstance != null) return mLoggerInstance;
            mLoggerInstance = new AtraceLogger(instrumentation);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mLoggerInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atraceStart(Set<String> traceCategoriesSet, int atraceBufferSize, int dumpIntervalSecs, File destDirectory, String traceFileName) throws IOException {
        if (this.mAtraceRunning) {
            throw new IllegalStateException("Attempted multiple atrace start");
        }
        if (traceCategoriesSet.isEmpty()) {
            throw new IllegalArgumentException("Empty categories. Should contain atleast one category");
        }
        if (destDirectory == null) {
            throw new IllegalArgumentException("Destination directory cannot be null");
        }
        if (!destDirectory.exists() && !destDirectory.mkdirs()) {
            throw new IOException("Unable to create the destination directory");
        }
        this.mDestAtraceDirectory = destDirectory;
        StringBuffer traceCategoriesList = new StringBuffer();
        for (String traceCategory : traceCategoriesSet) {
            traceCategoriesList.append(traceCategory).append(CATEGORY_SEPARATOR);
        }
        if (traceFileName != null && !traceFileName.isEmpty()) {
            this.mTraceFileName = traceFileName;
        }
        String startCommand = String.format(ATRACE_START, atraceBufferSize, traceCategoriesList.toString());
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            this.writeDataToByteStream(this.mUiAutomation.executeShellCommand(startCommand), outStream);
        }
        this.mAtraceRunning = true;
        this.mDumpIOException = null;
        this.mAtraceDataList = new ArrayList<ByteArrayOutputStream>();
        this.mDumpThread = new Thread(new DumpTraceRunnable(traceCategoriesList.toString(), atraceBufferSize, dumpIntervalSecs));
        this.mDumpThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataToByteStream(ParcelFileDescriptor pfDescriptor, ByteArrayOutputStream outputStream) throws IOException {
        try (ParcelFileDescriptor.AutoCloseInputStream inputStream = new ParcelFileDescriptor.AutoCloseInputStream(pfDescriptor);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, length);
            }
        }
    }

    public void atraceStop() throws IOException, InterruptedException {
        if (!this.mAtraceRunning) {
            throw new IllegalStateException("ATrace is not running currently. Start atrace beforestopping.");
        }
        try {
            this.mDumpThread.interrupt();
            this.mDumpThread.join();
            if (this.mDumpIOException != null) {
                throw this.mDumpIOException;
            }
            this.atraceWrite();
        }
        finally {
            for (ByteArrayOutputStream outStream : this.mAtraceDataList) {
                outStream.close();
            }
            this.mAtraceRunning = false;
            this.mTraceFileName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atraceWrite() throws IOException {
        int count = 0;
        for (ByteArrayOutputStream outStream : this.mAtraceDataList) {
            File file = null;
            file = this.mTraceFileName != null ? new File(this.mDestAtraceDirectory, String.format("%s-atrace-%d.txt", this.mTraceFileName, count)) : new File(this.mDestAtraceDirectory, String.format("atrace-%d.txt", count));
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                ((OutputStream)fileOutputStream).write(outStream.toByteArray());
            }
            ++count;
        }
    }

    private class DumpTraceRunnable
    implements Runnable {
        private String mTraceCategories;
        private int mBufferSize;
        private int mDumpIntervalInSecs;

        DumpTraceRunnable(String traceCategories, int bufferSize, int dumpIntervalInSecs) {
            this.mTraceCategories = traceCategories;
            this.mBufferSize = bufferSize;
            this.mDumpIntervalInSecs = dumpIntervalInSecs;
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(this.mDumpIntervalInSecs * 1000);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    String dumpCommand = String.format(AtraceLogger.ATRACE_DUMP, this.mBufferSize, this.mTraceCategories);
                    long startTime = System.currentTimeMillis();
                    ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
                    AtraceLogger.this.writeDataToByteStream(AtraceLogger.this.mUiAutomation.executeShellCommand(dumpCommand), byteArrayOutStream);
                    AtraceLogger.this.mAtraceDataList.add(byteArrayOutStream);
                    long endTime = System.currentTimeMillis();
                    long l = endTime - startTime;
                    Log.i((String)AtraceLogger.ATRACEHELPER_TAG, (String)new StringBuilder(54).append("Time taken by - DumpTraceRunnable ").append(l).toString());
                }
                String stopCommand = String.format(AtraceLogger.ATRACE_STOP, this.mBufferSize, this.mTraceCategories);
                ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
                AtraceLogger.this.writeDataToByteStream(AtraceLogger.this.mUiAutomation.executeShellCommand(stopCommand), byteArrayOutStream);
                AtraceLogger.this.mAtraceDataList.add(byteArrayOutStream);
            }
            catch (IOException ioe) {
                AtraceLogger.this.mDumpIOException = ioe;
            }
        }
    }
}

