/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule.provider;

import android.util.Log;
import java.io.File;

final class DatabaseArgs {
    private static final String TAG = "DatabaseArgs";
    private String mDBName;
    private String[] mDBCmds;
    private File mDBCmdFile;
    private File mDBDataFile;

    public DatabaseArgs(String dbName) {
        this.mDBName = dbName;
    }

    public void setDBCmds(String ... dbCmds) {
        if (this.mDBCmds != null) {
            Log.w((String)TAG, (String)String.format("Commands for database %s already set", this.mDBName));
        }
        this.mDBCmds = dbCmds;
    }

    public void setDBCmdFile(File dbCmdFile) {
        if (this.mDBCmdFile != null) {
            Log.w((String)TAG, (String)String.format("Command file for database %s already set", this.mDBName));
        }
        this.mDBCmdFile = dbCmdFile;
    }

    public void setDBDataFile(File dbDataFile) {
        if (this.mDBDataFile != null) {
            Log.w((String)TAG, (String)String.format("Data file to restore for database %s already set", this.mDBName));
        }
        this.mDBDataFile = dbDataFile;
    }

    public void addDBCmds(String ... dbCmds) {
        if (null == this.mDBCmds) {
            this.mDBCmds = dbCmds;
        } else {
            String[] newCmds = new String[this.mDBCmds.length + dbCmds.length];
            System.arraycopy(this.mDBCmds, 0, newCmds, 0, this.mDBCmds.length);
            System.arraycopy(dbCmds, 0, newCmds, this.mDBCmds.length, dbCmds.length);
            this.mDBCmds = newCmds;
        }
    }

    public boolean hasDBCmds() {
        return this.mDBCmds != null;
    }

    public boolean hasDBCmdFile() {
        return this.mDBCmdFile != null;
    }

    public boolean hasDBDataFile() {
        return this.mDBDataFile != null;
    }

    public String getDBName() {
        return this.mDBName;
    }

    public String[] getDBCmds() {
        return this.mDBCmds;
    }

    public File getDBCmdFile() {
        return this.mDBCmdFile;
    }

    public File getDBDataFile() {
        return this.mDBDataFile;
    }
}

