/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.statement;

import androidx.test.platform.app.InstrumentationRegistry;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.runners.model.Statement;

public class UiThreadStatement
extends Statement {
    private final Statement base;
    private final boolean runOnUiThread;

    public UiThreadStatement(Statement base, boolean runOnUiThread) {
        this.base = base;
        this.runOnUiThread = runOnUiThread;
    }

    public void evaluate() throws Throwable {
        if (this.runOnUiThread) {
            final AtomicReference exceptionRef = new AtomicReference();
            InstrumentationRegistry.getInstrumentation().runOnMainSync(new Runnable(){

                @Override
                public void run() {
                    try {
                        UiThreadStatement.this.base.evaluate();
                    }
                    catch (Throwable throwable) {
                        exceptionRef.set(throwable);
                    }
                }
            });
            Throwable throwable = (Throwable)exceptionRef.get();
            if (throwable != null) {
                throw throwable;
            }
        } else {
            this.base.evaluate();
        }
    }
}

