/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.junit4.statement.UiThreadStatement;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.rule.ActivityTestRule$$ExternalSyntheticLambda0;
import androidx.test.rule.ActivityTestRule$$ExternalSyntheticLambda1;
import androidx.test.runner.MonitoringInstrumentation;
import androidx.test.runner.intercepting.InterceptingActivityFactory;
import androidx.test.runner.intercepting.SingleActivityFactory;
import androidx.test.runner.lifecycle.ActivityLifecycleCallback;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Deprecated
public class ActivityTestRule<T extends Activity>
implements TestRule {
    private static final String TAG = "ActivityTestRule";
    private static final int NO_FLAGS_SET = 0;
    private static final String FIELD_RESULT_CODE = "mResultCode";
    private static final String FIELD_RESULT_DATA = "mResultData";
    private final Class<T> activityClass;
    private final String targetPackage;
    private final int launchFlags;
    private final ActivityLifecycleCallback lifecycleCallback = new LifecycleCallback();
    private Instrumentation instrumentation;
    private boolean initialTouchMode = false;
    private boolean launchActivity = false;
    private SingleActivityFactory<T> activityFactory;
    @VisibleForTesting
    volatile WeakReference<T> activity = this.makeWeakReference(null);
    private volatile Instrumentation.ActivityResult activityResult;

    public T getActivity() {
        Activity hardActivityRef = (Activity)this.activity.get();
        if (hardActivityRef == null) {
            Log.w((String)TAG, (String)"Activity wasn't created yet or already stopped");
        }
        return (T)hardActivityRef;
    }

    public T launchActivity(@Nullable Intent startIntent) {
        this.instrumentation.setInTouchMode(this.initialTouchMode);
        if (null == startIntent && null == (startIntent = this.getActivityIntent())) {
            Log.w((String)TAG, (String)"getActivityIntent() returned null using default: Intent(Intent.ACTION_MAIN)");
            startIntent = new Intent("android.intent.action.MAIN");
        }
        if (null == startIntent.getComponent()) {
            startIntent.setClassName(this.targetPackage, this.activityClass.getName());
        }
        if (0 == startIntent.getFlags()) {
            startIntent.addFlags(this.launchFlags);
        }
        this.beforeActivityLaunched();
        Activity hardActivityRef = (Activity)this.activityClass.cast(this.instrumentation.startActivitySync(startIntent));
        this.activity = this.makeWeakReference(hardActivityRef);
        this.instrumentation.waitForIdleSync();
        if (hardActivityRef != null) {
            ActivityLifecycleMonitorRegistry.getInstance().addLifecycleCallback(this.lifecycleCallback);
            this.afterActivityLaunched();
        } else {
            String errorMessage = String.format("Activity %s, failed to launch", startIntent.getComponent());
            Bundle bundle = new Bundle();
            String string = String.valueOf("ActivityTestRule ");
            String string2 = String.valueOf(errorMessage);
            bundle.putString("stream", string2.length() != 0 ? string.concat(string2) : new String(string));
            this.instrumentation.sendStatus(0, bundle);
            Log.e((String)TAG, (String)errorMessage);
        }
        return (T)hardActivityRef;
    }

    public Instrumentation.ActivityResult getActivityResult() {
        if (null == this.activityResult) {
            Activity hardActivityRef = (Activity)this.activity.get();
            Checks.checkNotNull((Object)hardActivityRef, (Object)"Activity wasn't created yet or already destroyed!");
            try {
                Activity activity = hardActivityRef;
                ActivityTestRule activityTestRule = this;
                this.runOnUiThread(new ActivityTestRule$$ExternalSyntheticLambda1(activityTestRule, activity));
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(throwable);
            }
        }
        return this.activityResult;
    }

    protected Intent getActivityIntent() {
        return null;
    }

    @VisibleForTesting
    WeakReference<T> makeWeakReference(T activity) {
        return new WeakReference<T>(activity);
    }

    public Statement apply(Statement base, Description description) {
        return new ActivityStatement(base);
    }

    public ActivityTestRule(Class<T> activityClass) {
        this(activityClass, false);
    }

    public ActivityTestRule(Class<T> activityClass, boolean initialTouchMode) {
        this(activityClass, initialTouchMode, true);
    }

    public ActivityTestRule(SingleActivityFactory<T> activityFactory, boolean initialTouchMode, boolean launchActivity) {
        this(activityFactory.getActivityClassToIntercept(), initialTouchMode, launchActivity);
        this.activityFactory = activityFactory;
    }

    public ActivityTestRule(Class<T> activityClass, boolean initialTouchMode, boolean launchActivity) {
        this(activityClass, InstrumentationRegistry.getInstrumentation().getTargetContext().getPackageName(), 0x10000000, initialTouchMode, launchActivity);
    }

    public ActivityTestRule(Class<T> activityClass, @NonNull String targetPackage, int launchFlags, boolean initialTouchMode, boolean launchActivity) {
        this.instrumentation = InstrumentationRegistry.getInstrumentation();
        this.activityClass = activityClass;
        this.targetPackage = (String)Checks.checkNotNull((Object)targetPackage, (Object)"targetPackage cannot be null!");
        this.launchFlags = launchFlags;
        this.initialTouchMode = initialTouchMode;
        this.launchActivity = launchActivity;
    }

    protected void afterActivityFinished() {
    }

    protected void afterActivityLaunched() {
    }

    protected void beforeActivityLaunched() {
    }

    @VisibleForTesting
    void callFinishOnMainSync() {
        try {
            Activity hardActivityRef;
            Activity activity = hardActivityRef = (Activity)this.activity.get();
            ActivityTestRule activityTestRule = this;
            this.runOnUiThread(new ActivityTestRule$$ExternalSyntheticLambda0(activityTestRule, activity));
            this.instrumentation.waitForIdleSync();
        }
        catch (Throwable throwable) {
            String msg = "Failed to execute activity.finish() on the main thread";
            Log.e((String)TAG, (String)msg, (Throwable)throwable);
            throw new IllegalStateException(msg, throwable);
        }
    }

    public void finishActivity() {
        try {
            if (this.activity.get() != null) {
                this.callFinishOnMainSync();
            }
        }
        finally {
            this.activity = this.makeWeakReference(null);
            this.afterActivityFinished();
        }
    }

    /* synthetic */ void lambda$callFinishOnMainSync$0$androidx-test-rule-ActivityTestRule(Activity hardActivityRef) {
        Checks.checkState((hardActivityRef != null ? 1 : 0) != 0, (Object)"Activity was not launched. If you manually finished it, you must launch it again before finishing it. ");
        hardActivityRef.finish();
        this.setActivityResultForActivity(hardActivityRef);
    }

    /* synthetic */ void lambda$getActivityResult$1$androidx-test-rule-ActivityTestRule(Activity hardActivityRef) {
        Checks.checkState((boolean)hardActivityRef.isFinishing(), (Object)"Activity is not finishing!");
        this.setActivityResultForActivity(hardActivityRef);
    }

    public void runOnUiThread(Runnable runnable) throws Throwable {
        UiThreadStatement.runOnUiThread((Runnable)runnable);
    }

    private void setActivityResultForActivity(T activity) {
        Checks.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0, (Object)"Must be called on the main thread!");
        Checks.checkNotNull(activity, (Object)"Activity wasn't created yet or already destroyed!");
        try {
            Field resultCodeField = Activity.class.getDeclaredField(FIELD_RESULT_CODE);
            resultCodeField.setAccessible(true);
            Field resultDataField = Activity.class.getDeclaredField(FIELD_RESULT_DATA);
            resultDataField.setAccessible(true);
            this.activityResult = new Instrumentation.ActivityResult(((Integer)resultCodeField.get(activity)).intValue(), (Intent)resultDataField.get(activity));
        }
        catch (NoSuchFieldException e) {
            String msg = "Looks like the Android Activity class has changed itsprivate fields for mResultCode or mResultData. Time to update the reflection code.";
            Log.e((String)TAG, (String)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Field mResultCode or mResultData is not accessible";
            Log.e((String)TAG, (String)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    @VisibleForTesting
    void setInstrumentation(Instrumentation instrumentation) {
        this.instrumentation = (Instrumentation)Checks.checkNotNull((Object)instrumentation, (Object)"instrumentation cannot be null!");
    }

    private class LifecycleCallback
    implements ActivityLifecycleCallback {
        private LifecycleCallback() {
        }

        public void onActivityLifecycleChanged(Activity activity, Stage stage) {
            if (ActivityTestRule.this.activityClass.isInstance(activity)) {
                if (Stage.RESUMED == stage) {
                    ActivityTestRule.this.activity = ActivityTestRule.this.makeWeakReference((Activity)ActivityTestRule.this.activityClass.cast(activity));
                } else if (Stage.PAUSED == stage && activity.isFinishing() && ActivityTestRule.this.activityResult != null) {
                    ActivityTestRule.this.setActivityResultForActivity((Activity)ActivityTestRule.this.activityClass.cast(activity));
                }
            }
        }
    }

    private class ActivityStatement
    extends Statement {
        private final Statement base;

        public ActivityStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            MonitoringInstrumentation instrumentation = ActivityTestRule.this.instrumentation instanceof MonitoringInstrumentation ? (MonitoringInstrumentation)ActivityTestRule.this.instrumentation : null;
            try {
                if (ActivityTestRule.this.activityFactory != null && instrumentation != null) {
                    instrumentation.interceptActivityUsing((InterceptingActivityFactory)ActivityTestRule.this.activityFactory);
                }
                if (ActivityTestRule.this.launchActivity) {
                    ActivityTestRule.this.launchActivity(ActivityTestRule.this.getActivityIntent());
                }
                this.base.evaluate();
            }
            finally {
                Activity hardActivityRef;
                if (instrumentation != null) {
                    instrumentation.useDefaultInterceptingActivityFactory();
                }
                if ((hardActivityRef = (Activity)ActivityTestRule.this.activity.get()) != null) {
                    ActivityTestRule.this.finishActivity();
                }
                ActivityTestRule.this.activityResult = null;
                ActivityLifecycleMonitorRegistry.getInstance().removeLifecycleCallback(ActivityTestRule.this.lifecycleCallback);
            }
        }
    }
}

