/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule.provider;

import android.util.Log;
import java.io.File;

final class DatabaseArgs {
    private static final String TAG = "DatabaseArgs";
    private String dBName;
    private String[] dBCmds;
    private File dBCmdFile;
    private File dBDataFile;

    public File getDBCmdFile() {
        return this.dBCmdFile;
    }

    public File getDBDataFile() {
        return this.dBDataFile;
    }

    public String getDBName() {
        return this.dBName;
    }

    public DatabaseArgs(String dbName) {
        this.dBName = dbName;
    }

    public void addDBCmds(String ... dbCmds) {
        if (null == this.dBCmds) {
            this.dBCmds = dbCmds;
        } else {
            String[] newCmds = new String[this.dBCmds.length + dbCmds.length];
            System.arraycopy(this.dBCmds, 0, newCmds, 0, this.dBCmds.length);
            System.arraycopy(dbCmds, 0, newCmds, this.dBCmds.length, dbCmds.length);
            this.dBCmds = newCmds;
        }
    }

    public void setDBCmdFile(File dbCmdFile) {
        if (this.dBCmdFile != null) {
            Log.w((String)TAG, (String)String.format("Command file for database %s already set", this.dBName));
        }
        this.dBCmdFile = dbCmdFile;
    }

    public void setDBCmds(String ... dbCmds) {
        if (this.dBCmds != null) {
            Log.w((String)TAG, (String)String.format("Commands for database %s already set", this.dBName));
        }
        this.dBCmds = dbCmds;
    }

    public void setDBDataFile(File dbDataFile) {
        if (this.dBDataFile != null) {
            Log.w((String)TAG, (String)String.format("Data file to restore for database %s already set", this.dBName));
        }
        this.dBDataFile = dbDataFile;
    }

    public boolean hasDBCmdFile() {
        return this.dBCmdFile != null;
    }

    public boolean hasDBCmds() {
        return this.dBCmds != null;
    }

    public boolean hasDBDataFile() {
        return this.dBDataFile != null;
    }

    public String[] getDBCmds() {
        return this.dBCmds;
    }
}

