/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule.provider;

import android.content.ContentProvider;
import android.util.Log;
import java.io.File;
import java.lang.ref.WeakReference;

final class ProviderArgs {
    private static final String TAG = "ProviderArgs";
    private final String authority;
    private final Class<? extends ContentProvider> providerClass;
    private String dBName;
    private String[] dBCmds;
    private File dBCmdFile;
    private File dBDataFile;
    private WeakReference<ContentProvider> providerRef;

    public ContentProvider getProvider() {
        if (this.providerRef != null) {
            return (ContentProvider)this.providerRef.get();
        }
        return null;
    }

    public File getDBCmdFile() {
        return this.dBCmdFile;
    }

    public File getDBDataFile() {
        return this.dBDataFile;
    }

    public Class<? extends ContentProvider> getProviderClass() {
        return this.providerClass;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getDBName() {
        return this.dBName;
    }

    public ProviderArgs(String authority, Class<? extends ContentProvider> providerClass) {
        this.authority = authority;
        this.providerClass = providerClass;
    }

    public void addDBCmds(String ... dbCmds) {
        if (null == this.dBCmds) {
            this.dBCmds = dbCmds;
        } else {
            String[] newCmds = new String[this.dBCmds.length + dbCmds.length];
            System.arraycopy(this.dBCmds, 0, newCmds, 0, this.dBCmds.length);
            System.arraycopy(dbCmds, 0, newCmds, this.dBCmds.length, dbCmds.length);
            this.dBCmds = newCmds;
        }
    }

    public void setDBCmdFile(File dbCmdFile) {
        if (this.dBCmdFile != null) {
            Log.w((String)TAG, (String)String.format("Database command file for ContentProvider with authority %s already set", this.authority));
        }
        this.dBCmdFile = dbCmdFile;
    }

    public void setDBCmds(String ... dbCmds) {
        if (this.dBCmds != null) {
            Log.w((String)TAG, (String)String.format("Database commands for ContentProvider with authority %s already set", this.authority));
        }
        this.dBCmds = dbCmds;
    }

    public void setDBDataFile(File dbDataFile) {
        if (this.dBDataFile != null) {
            Log.w((String)TAG, (String)String.format("Database file to restore for ContentProvider with authority %s already set", this.authority));
        }
        this.dBDataFile = dbDataFile;
    }

    public void setDBName(String dbName) {
        if (this.dBName != null) {
            Log.w((String)TAG, (String)String.format("Database name for ContentProvider with authority %s already exists", this.authority));
        }
        this.dBName = dbName;
    }

    public void setProviderRef(ContentProvider provider) {
        if (this.providerRef != null) {
            Log.w((String)TAG, (String)String.format("Reference to Provider instance with authority %s already set", this.authority));
        }
        this.providerRef = new WeakReference<ContentProvider>(provider);
    }

    public boolean hasDBCmdFile() {
        return this.dBCmdFile != null;
    }

    public boolean hasDBCmds() {
        return this.dBCmds != null;
    }

    public boolean hasDBDataFile() {
        return this.dBDataFile != null;
    }

    public boolean hasDBName() {
        return this.dBName != null;
    }

    public String[] getDBCmds() {
        return this.dBCmds;
    }
}

