/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule.logging;

import android.app.Instrumentation;
import android.app.UiAutomation;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

@Deprecated
@RequiresApi(value=21)
public class AtraceLogger {
    private static final String ATRACE_START = "atrace --async_start -b %d -c %s";
    private static final String ATRACE_DUMP = "atrace --async_dump -b %d -z %s";
    private static final String ATRACE_STOP = "atrace --async_stop -b %d -z %s";
    private static final String ATRACEHELPER_TAG = "AtraceLogger";
    private static final String CATEGORY_SEPARATOR = " ";
    private static final int BUFFER_SIZE = 8192;
    private static volatile AtraceLogger loggerInstance;
    private UiAutomation uiAutomation;
    private String traceFileName;
    private List<ByteArrayOutputStream> atraceDataList;
    private Thread dumpThread;
    private File destAtraceDirectory;
    private boolean atraceRunning = false;
    private IOException dumpIOException;

    private AtraceLogger(Instrumentation instrumentation) {
        this.uiAutomation = instrumentation.getUiAutomation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtraceLogger getAtraceLoggerInstance(Instrumentation instrumentation) {
        if (Build.VERSION.SDK_INT < 21) {
            throw new UnsupportedOperationException("AtraceLogger is only supported on APIs >= 21");
        }
        if (loggerInstance != null) return loggerInstance;
        Class<AtraceLogger> clazz = AtraceLogger.class;
        synchronized (AtraceLogger.class) {
            if (loggerInstance != null) return loggerInstance;
            loggerInstance = new AtraceLogger(instrumentation);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loggerInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atraceStart(Set<String> traceCategoriesSet, int atraceBufferSize, int dumpIntervalSecs, File destDirectory, String traceFileName) throws IOException {
        if (this.atraceRunning) {
            throw new IllegalStateException("Attempted multiple atrace start");
        }
        if (traceCategoriesSet.isEmpty()) {
            throw new IllegalArgumentException("Empty categories. Should contain atleast one category");
        }
        if (destDirectory == null) {
            throw new IllegalArgumentException("Destination directory cannot be null");
        }
        if (!destDirectory.exists() && !destDirectory.mkdirs()) {
            throw new IOException("Unable to create the destination directory");
        }
        this.destAtraceDirectory = destDirectory;
        StringBuffer traceCategoriesList = new StringBuffer();
        for (String traceCategory : traceCategoriesSet) {
            traceCategoriesList.append(traceCategory).append(CATEGORY_SEPARATOR);
        }
        if (traceFileName != null && !traceFileName.isEmpty()) {
            this.traceFileName = traceFileName;
        }
        String startCommand = String.format(ATRACE_START, atraceBufferSize, traceCategoriesList.toString());
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            this.writeDataToByteStream(this.uiAutomation.executeShellCommand(startCommand), outStream);
        }
        this.atraceRunning = true;
        this.dumpIOException = null;
        this.atraceDataList = new ArrayList<ByteArrayOutputStream>();
        DumpTraceRunnable dumpTraceRunnable = new DumpTraceRunnable(traceCategoriesList.toString(), atraceBufferSize, dumpIntervalSecs);
        this.dumpThread = new Thread(dumpTraceRunnable);
        this.dumpThread.start();
        dumpTraceRunnable.waitForStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataToByteStream(ParcelFileDescriptor pfDescriptor, ByteArrayOutputStream outputStream) throws IOException {
        try (ParcelFileDescriptor.AutoCloseInputStream inputStream = new ParcelFileDescriptor.AutoCloseInputStream(pfDescriptor);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, length);
            }
        }
    }

    public void atraceStop() throws IOException, InterruptedException {
        if (!this.atraceRunning) {
            throw new IllegalStateException("ATrace is not running currently. Start atrace beforestopping.");
        }
        try {
            this.dumpThread.interrupt();
            this.dumpThread.join();
            if (this.dumpIOException != null) {
                throw this.dumpIOException;
            }
            this.atraceWrite();
        }
        finally {
            for (ByteArrayOutputStream outStream : this.atraceDataList) {
                outStream.close();
            }
            this.atraceRunning = false;
            this.traceFileName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atraceWrite() throws IOException {
        int count = 0;
        for (ByteArrayOutputStream outStream : this.atraceDataList) {
            File file = null;
            file = this.traceFileName != null ? new File(this.destAtraceDirectory, String.format("%s-atrace-%d.txt", this.traceFileName, count)) : new File(this.destAtraceDirectory, String.format("atrace-%d.txt", count));
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                ((OutputStream)fileOutputStream).write(outStream.toByteArray());
            }
            ++count;
        }
    }

    private class DumpTraceRunnable
    implements Runnable {
        private String traceCategories;
        private int bufferSize;
        private int dumpIntervalInSecs;
        private final CountDownLatch startLatch = new CountDownLatch(1);

        DumpTraceRunnable(String traceCategories, int bufferSize, int dumpIntervalInSecs) {
            this.traceCategories = traceCategories;
            this.bufferSize = bufferSize;
            this.dumpIntervalInSecs = dumpIntervalInSecs;
        }

        void waitForStart() {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.startLatch.countDown();
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(this.dumpIntervalInSecs * 1000);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    String dumpCommand = String.format(AtraceLogger.ATRACE_DUMP, this.bufferSize, this.traceCategories);
                    long startTime = System.currentTimeMillis();
                    ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
                    AtraceLogger.this.writeDataToByteStream(AtraceLogger.this.uiAutomation.executeShellCommand(dumpCommand), byteArrayOutStream);
                    AtraceLogger.this.atraceDataList.add(byteArrayOutStream);
                    long endTime = System.currentTimeMillis();
                    Log.i((String)AtraceLogger.ATRACEHELPER_TAG, (String)("Time taken by - DumpTraceRunnable " + (endTime - startTime)));
                }
                String stopCommand = String.format(AtraceLogger.ATRACE_STOP, this.bufferSize, this.traceCategories);
                ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
                AtraceLogger.this.writeDataToByteStream(AtraceLogger.this.uiAutomation.executeShellCommand(stopCommand), byteArrayOutStream);
                AtraceLogger.this.atraceDataList.add(byteArrayOutStream);
            }
            catch (IOException ioe) {
                AtraceLogger.this.dumpIOException = ioe;
            }
        }
    }
}

