/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit3;

import android.util.Log;
import androidx.test.internal.runner.junit3.AndroidTestSuite;
import androidx.test.internal.runner.junit3.JUnit38ClassRunner;
import androidx.test.internal.util.AndroidRunnerBuilderUtil;
import androidx.test.internal.util.AndroidRunnerParams;
import junit.framework.Test;
import org.junit.internal.builders.JUnit3Builder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class AndroidJUnit3Builder
extends JUnit3Builder {
    private static final String TAG = "AndroidJUnit3Builder";
    public static final Runner NOT_A_VALID_TEST = new Runner(){

        public Description getDescription() {
            return Description.EMPTY;
        }

        public void run(RunNotifier notifier) {
        }
    };
    private final AndroidRunnerParams mAndroidRunnerParams;
    private final boolean mScanningPath;

    public AndroidJUnit3Builder(AndroidRunnerParams runnerParams, boolean scanningPath) {
        this.mAndroidRunnerParams = runnerParams;
        this.mScanningPath = scanningPath;
    }

    @Deprecated
    public AndroidJUnit3Builder(AndroidRunnerParams runnerParams) {
        this(runnerParams, false);
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        try {
            if (AndroidRunnerBuilderUtil.isJUnit3Test(testClass)) {
                if (this.mScanningPath && !AndroidRunnerBuilderUtil.hasJUnit3TestMethod(testClass)) {
                    return NOT_A_VALID_TEST;
                }
                return new JUnit38ClassRunner((Test)new AndroidTestSuite(testClass, this.mAndroidRunnerParams));
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Error constructing runner", (Throwable)e);
            throw e;
        }
        return null;
    }
}

