/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import java.io.PrintStream;
import org.junit.internal.TextListener;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class InstrumentationResultPrinter
extends InstrumentationRunListener {
    private static final String TAG = "InstrumentationResultPrinter";
    @VisibleForTesting
    static final int MAX_TRACE_SIZE = 32768;
    public static final String REPORT_VALUE_ID = "AndroidJUnitRunner";
    public static final String REPORT_KEY_NUM_TOTAL = "numtests";
    public static final String REPORT_KEY_NUM_CURRENT = "current";
    public static final String REPORT_KEY_NAME_CLASS = "class";
    public static final String REPORT_KEY_NAME_TEST = "test";
    public static final int REPORT_VALUE_RESULT_START = 1;
    public static final int REPORT_VALUE_RESULT_OK = 0;
    @Deprecated
    public static final int REPORT_VALUE_RESULT_ERROR = -1;
    public static final int REPORT_VALUE_RESULT_FAILURE = -2;
    public static final int REPORT_VALUE_RESULT_IGNORED = -3;
    public static final int REPORT_VALUE_RESULT_ASSUMPTION_FAILURE = -4;
    public static final String REPORT_KEY_STACK = "stack";
    private final Bundle mResultTemplate;
    @VisibleForTesting
    Bundle mTestResult;
    int mTestNum = 0;
    int mTestResultCode = -999;
    String mTestClass = null;
    private Description mDescription = Description.EMPTY;

    public InstrumentationResultPrinter() {
        this.mResultTemplate = new Bundle();
        this.mTestResult = new Bundle(this.mResultTemplate);
    }

    public void testRunStarted(Description description) throws Exception {
        this.mResultTemplate.putString("id", REPORT_VALUE_ID);
        this.mResultTemplate.putInt(REPORT_KEY_NUM_TOTAL, description.testCount());
    }

    public void testStarted(Description description) throws Exception {
        this.mDescription = description;
        String testClass = description.getClassName();
        String testName = description.getMethodName();
        this.mTestResult = new Bundle(this.mResultTemplate);
        this.mTestResult.putString(REPORT_KEY_NAME_CLASS, testClass);
        this.mTestResult.putString(REPORT_KEY_NAME_TEST, testName);
        this.mTestResult.putInt(REPORT_KEY_NUM_CURRENT, ++this.mTestNum);
        if (testClass != null && !testClass.equals(this.mTestClass)) {
            this.mTestResult.putString("stream", String.format("\n%s:", testClass));
            this.mTestClass = testClass;
        } else {
            this.mTestResult.putString("stream", "");
        }
        this.sendStatus(1, this.mTestResult);
        this.mTestResultCode = 0;
    }

    public void testFinished(Description description) throws Exception {
        if (this.mTestResultCode == 0) {
            this.mTestResult.putString("stream", ".");
        }
        this.sendStatus(this.mTestResultCode, this.mTestResult);
    }

    public void testFailure(Failure failure) throws Exception {
        boolean shouldCallFinish = false;
        if (this.mDescription.equals((Object)Description.EMPTY) && this.mTestNum == 0 && this.mTestClass == null) {
            this.testStarted(failure.getDescription());
            shouldCallFinish = true;
        }
        this.mTestResultCode = -2;
        this.reportFailure(failure);
        if (shouldCallFinish) {
            this.testFinished(failure.getDescription());
        }
    }

    public void testAssumptionFailure(Failure failure) {
        this.mTestResultCode = -4;
        this.mTestResult.putString(REPORT_KEY_STACK, failure.getTrace());
    }

    private void reportFailure(Failure failure) {
        String trace = failure.getTrace();
        if (trace.length() > 32768) {
            Log.w((String)TAG, (String)String.format("Stack trace too long, trimmed to first %s characters.", 32768));
            trace = String.valueOf(trace.substring(0, 32768)).concat("\n");
        }
        this.mTestResult.putString(REPORT_KEY_STACK, trace);
        this.mTestResult.putString("stream", String.format("\nError in %s:\n%s", failure.getDescription().getDisplayName(), failure.getTrace()));
    }

    public void testIgnored(Description description) throws Exception {
        this.testStarted(description);
        this.mTestResultCode = -3;
        this.testFinished(description);
    }

    public void reportProcessCrash(Throwable t) {
        try {
            this.mTestResultCode = -2;
            Failure failure = new Failure(this.mDescription, t);
            this.mTestResult.putString(REPORT_KEY_STACK, failure.getTrace());
            this.mTestResult.putString("stream", String.format("\nProcess crashed while executing %s:\n%s", this.mDescription.getDisplayName(), failure.getTrace()));
            this.testFinished(this.mDescription);
        }
        catch (Exception e) {
            if (null == this.mDescription) {
                Log.e((String)TAG, (String)"Failed to initialize test before process crash");
            }
            String string = this.mDescription.getDisplayName();
            Log.e((String)TAG, (String)new StringBuilder(52 + String.valueOf(string).length()).append("Failed to mark test ").append(string).append(" as finished after process crash").toString());
        }
    }

    @Override
    public void instrumentationRunFinished(PrintStream streamResult, Bundle resultBundle, Result junitResults) {
        new TextListener(streamResult).testRunFinished(junitResults);
    }
}

