/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.junit3.AndroidJUnit3Builder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.RunnerBuilder;

class TestLoader {
    private static final String LOG_TAG = "TestLoader";
    private final ClassLoader classLoader;
    private final RunnerBuilder runnerBuilder;
    private final Map<String, Runner> runnersMap = new LinkedHashMap<String, Runner>();

    static TestLoader testLoader(ClassLoader classLoader, RunnerBuilder runnerBuilder, boolean scanningPath) {
        if (scanningPath) {
            runnerBuilder = new ScanningRunnerBuilder(runnerBuilder);
        }
        if (null == classLoader) {
            classLoader = TestLoader.class.getClassLoader();
        }
        return new TestLoader(classLoader, runnerBuilder);
    }

    private TestLoader(ClassLoader classLoader, RunnerBuilder runnerBuilder) {
        this.classLoader = classLoader;
        this.runnerBuilder = runnerBuilder;
    }

    private void doCreateRunner(String className, boolean isScanningPath) {
        Runner runner;
        block7: {
            if (this.runnersMap.containsKey(className)) {
                return;
            }
            try {
                Class<?> loadedClass = Class.forName(className, false, this.classLoader);
                runner = this.runnerBuilder.safeRunnerForClass(loadedClass);
                if (null == runner) {
                    TestLoader.logDebug(String.format("Skipping class %s: not a test", loadedClass.getName()));
                } else if (runner == AndroidJUnit3Builder.NOT_A_VALID_TEST) {
                    TestLoader.logDebug(String.format("Skipping class %s: not a valid test", loadedClass.getName()));
                    runner = null;
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                String errMsg = String.format("Could not find class: %s", className);
                Log.e((String)LOG_TAG, (String)errMsg);
                Description description = Description.createSuiteDescription((String)className, (Annotation[])new Annotation[0]);
                Failure failure = new Failure(description, e);
                runner = null;
                if (isScanningPath) break block7;
                runner = new UnloadableClassRunner(description, failure);
            }
        }
        if (runner != null) {
            this.runnersMap.put(className, runner);
        }
    }

    List<Runner> getRunnersFor(Collection<String> classNames, boolean isScanningPath) {
        for (String className : classNames) {
            this.doCreateRunner(className, isScanningPath);
        }
        return new ArrayList<Runner>(this.runnersMap.values());
    }

    private static void logDebug(String msg) {
        if (Log.isLoggable((String)LOG_TAG, (int)3)) {
            Log.d((String)LOG_TAG, (String)msg);
        }
    }

    @VisibleForTesting
    static class UnloadableClassRunner
    extends Runner {
        private final Description description;
        private final Failure failure;

        UnloadableClassRunner(Description description, Failure failure) {
            this.description = description;
            this.failure = failure;
        }

        public Description getDescription() {
            return this.description;
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestStarted(this.description);
            notifier.fireTestFailure(this.failure);
            notifier.fireTestFinished(this.description);
        }
    }

    private static class ScanningRunnerBuilder
    extends RunnerBuilder {
        private final RunnerBuilder runnerBuilder;

        ScanningRunnerBuilder(RunnerBuilder runnerBuilder) {
            this.runnerBuilder = runnerBuilder;
        }

        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            if (Modifier.isAbstract(testClass.getModifiers())) {
                TestLoader.logDebug(String.format("Skipping abstract class %s: not a test", testClass.getName()));
                return null;
            }
            return this.runnerBuilder.runnerForClass(testClass);
        }
    }
}

