/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class AndroidRunnerBuilderUtil {
    public static boolean isJUnit3Test(Class<?> testClass) {
        return TestCase.class.isAssignableFrom(testClass);
    }

    public static boolean isJUnit3TestSuite(Class<?> testClass) {
        return TestSuite.class.isAssignableFrom(testClass);
    }

    public static boolean hasSuiteMethod(Class<?> testClass) {
        try {
            testClass.getMethod("suite", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public static boolean hasJUnit3TestMethod(Class<?> loadedClass) {
        for (Method testMethod : loadedClass.getMethods()) {
            if (!AndroidRunnerBuilderUtil.isPublicTestMethod(testMethod)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPublicTestMethod(Method m) {
        return AndroidRunnerBuilderUtil.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private static boolean isTestMethod(Method m) {
        return m.getParameterTypes().length == 0 && m.getName().startsWith("test") && m.getReturnType().equals(Void.TYPE);
    }
}

