/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.internal.deps.desugar;

import java.io.Closeable;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public final class ThrowableExtension {
    static final AbstractDesugaringStrategy STRATEGY;
    public static final String SYSTEM_PROPERTY_TWR_DISABLE_MIMIC = "androidx.test.runner.internal.deps.desugar.twr_disable_mimic";
    static final int API_LEVEL;
    private static final String ANDROID_OS_BUILD_VERSION = "android.os.Build$VERSION";

    public static AbstractDesugaringStrategy getStrategy() {
        return STRATEGY;
    }

    public static void addSuppressed(Throwable receiver, Throwable suppressed) {
        STRATEGY.addSuppressed(receiver, suppressed);
    }

    public static Throwable[] getSuppressed(Throwable receiver) {
        return STRATEGY.getSuppressed(receiver);
    }

    public static void printStackTrace(Throwable receiver) {
        STRATEGY.printStackTrace(receiver);
    }

    public static void printStackTrace(Throwable receiver, PrintWriter writer) {
        STRATEGY.printStackTrace(receiver, writer);
    }

    public static void printStackTrace(Throwable receiver, PrintStream stream) {
        STRATEGY.printStackTrace(receiver, stream);
    }

    public static void closeResource(Throwable throwable, Object resource) throws Throwable {
        block10: {
            if (resource == null) {
                return;
            }
            try {
                if (API_LEVEL >= 19) {
                    ((AutoCloseable)resource).close();
                    break block10;
                }
                if (resource instanceof Closeable) {
                    ((Closeable)resource).close();
                    break block10;
                }
                try {
                    Method method = resource.getClass().getMethod("close", new Class[0]);
                    method.invoke(resource, new Object[0]);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    String string = String.valueOf(resource.getClass());
                    throw new AssertionError(new StringBuilder(32 + String.valueOf(string).length()).append(string).append(" does not have a close() method.").toString(), e);
                }
                catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException e) {
                    String string = String.valueOf(resource.getClass());
                    throw new AssertionError(new StringBuilder(24 + String.valueOf(string).length()).append("Fail to call close() on ").append(string).toString(), e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    throw cause;
                }
            }
            catch (Throwable e) {
                if (throwable != null) {
                    ThrowableExtension.addSuppressed(throwable, e);
                    throw throwable;
                }
                throw e;
            }
        }
    }

    private static boolean useMimicStrategy() {
        return !Boolean.getBoolean(SYSTEM_PROPERTY_TWR_DISABLE_MIMIC);
    }

    private static Integer readApiLevelFromBuildVersion() {
        try {
            Class<?> buildVersionClass = Class.forName(ANDROID_OS_BUILD_VERSION);
            Field field = buildVersionClass.getField("SDK_INT");
            return (Integer)field.get(null);
        }
        catch (Exception e) {
            System.err.println("Failed to retrieve value from android.os.Build$VERSION.SDK_INT due to the following exception.");
            e.printStackTrace(System.err);
            return null;
        }
    }

    static {
        AbstractDesugaringStrategy strategy;
        Integer apiLevel = null;
        try {
            apiLevel = ThrowableExtension.readApiLevelFromBuildVersion();
            strategy = apiLevel != null && apiLevel >= 19 ? new ReuseDesugaringStrategy() : (ThrowableExtension.useMimicStrategy() ? new MimicDesugaringStrategy() : new NullDesugaringStrategy());
        }
        catch (Throwable e) {
            String string = NullDesugaringStrategy.class.getName();
            System.err.println(new StringBuilder(133 + String.valueOf(string).length()).append("An error has occurred when initializing the try-with-resources desuguring strategy. The default strategy ").append(string).append("will be used. The error is: ").toString());
            e.printStackTrace(System.err);
            strategy = new NullDesugaringStrategy();
        }
        STRATEGY = strategy;
        API_LEVEL = apiLevel == null ? 1 : apiLevel;
    }

    static final class NullDesugaringStrategy
    extends AbstractDesugaringStrategy {
        NullDesugaringStrategy() {
        }

        @Override
        public void addSuppressed(Throwable receiver, Throwable suppressed) {
        }

        @Override
        public Throwable[] getSuppressed(Throwable receiver) {
            return EMPTY_THROWABLE_ARRAY;
        }

        @Override
        public void printStackTrace(Throwable receiver) {
            receiver.printStackTrace();
        }

        @Override
        public void printStackTrace(Throwable receiver, PrintStream stream) {
            receiver.printStackTrace(stream);
        }

        @Override
        public void printStackTrace(Throwable receiver, PrintWriter writer) {
            receiver.printStackTrace(writer);
        }
    }

    static final class ConcurrentWeakIdentityHashMap {
        private final ConcurrentHashMap<WeakKey, List<Throwable>> map = new ConcurrentHashMap(16, 0.75f, 10);
        private final ReferenceQueue<Throwable> referenceQueue = new ReferenceQueue();

        ConcurrentWeakIdentityHashMap() {
        }

        public List<Throwable> get(Throwable throwable, boolean createOnAbsence) {
            this.deleteEmptyKeys();
            WeakKey keyForQuery = new WeakKey(throwable, null);
            List list = this.map.get(keyForQuery);
            if (!createOnAbsence) {
                return list;
            }
            if (list != null) {
                return list;
            }
            Vector newValue = new Vector(2);
            list = this.map.putIfAbsent(new WeakKey(throwable, this.referenceQueue), newValue);
            return list == null ? newValue : list;
        }

        int size() {
            return this.map.size();
        }

        void deleteEmptyKeys() {
            Reference<Throwable> key = this.referenceQueue.poll();
            while (key != null) {
                this.map.remove(key);
                key = this.referenceQueue.poll();
            }
        }

        private static final class WeakKey
        extends WeakReference<Throwable> {
            private final int hash;

            public WeakKey(Throwable referent, ReferenceQueue<Throwable> q) {
                super(referent, q);
                if (referent == null) {
                    throw new NullPointerException("The referent cannot be null");
                }
                this.hash = System.identityHashCode(referent);
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object obj) {
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                if (this == obj) {
                    return true;
                }
                WeakKey other = (WeakKey)obj;
                return this.hash == other.hash && this.get() == other.get();
            }
        }
    }

    static final class MimicDesugaringStrategy
    extends AbstractDesugaringStrategy {
        static final String SUPPRESSED_PREFIX = "Suppressed: ";
        private final ConcurrentWeakIdentityHashMap map = new ConcurrentWeakIdentityHashMap();

        MimicDesugaringStrategy() {
        }

        @Override
        public void addSuppressed(Throwable receiver, Throwable suppressed) {
            if (suppressed == receiver) {
                throw new IllegalArgumentException("Self suppression is not allowed.", suppressed);
            }
            if (suppressed == null) {
                throw new NullPointerException("The suppressed exception cannot be null.");
            }
            this.map.get(receiver, true).add(suppressed);
        }

        @Override
        public Throwable[] getSuppressed(Throwable receiver) {
            List<Throwable> list = this.map.get(receiver, false);
            if (list == null || list.isEmpty()) {
                return EMPTY_THROWABLE_ARRAY;
            }
            return list.toArray(EMPTY_THROWABLE_ARRAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void printStackTrace(Throwable receiver) {
            receiver.printStackTrace();
            List<Throwable> suppressedList = this.map.get(receiver, false);
            if (suppressedList == null) {
                return;
            }
            List<Throwable> list = suppressedList;
            synchronized (list) {
                for (Throwable suppressed : suppressedList) {
                    System.err.print(SUPPRESSED_PREFIX);
                    suppressed.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void printStackTrace(Throwable receiver, PrintStream stream) {
            receiver.printStackTrace(stream);
            List<Throwable> suppressedList = this.map.get(receiver, false);
            if (suppressedList == null) {
                return;
            }
            List<Throwable> list = suppressedList;
            synchronized (list) {
                for (Throwable suppressed : suppressedList) {
                    stream.print(SUPPRESSED_PREFIX);
                    suppressed.printStackTrace(stream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void printStackTrace(Throwable receiver, PrintWriter writer) {
            receiver.printStackTrace(writer);
            List<Throwable> suppressedList = this.map.get(receiver, false);
            if (suppressedList == null) {
                return;
            }
            List<Throwable> list = suppressedList;
            synchronized (list) {
                for (Throwable suppressed : suppressedList) {
                    writer.print(SUPPRESSED_PREFIX);
                    suppressed.printStackTrace(writer);
                }
            }
        }
    }

    static final class ReuseDesugaringStrategy
    extends AbstractDesugaringStrategy {
        ReuseDesugaringStrategy() {
        }

        @Override
        public void addSuppressed(Throwable receiver, Throwable suppressed) {
            receiver.addSuppressed(suppressed);
        }

        @Override
        public Throwable[] getSuppressed(Throwable receiver) {
            return receiver.getSuppressed();
        }

        @Override
        public void printStackTrace(Throwable receiver) {
            receiver.printStackTrace();
        }

        @Override
        public void printStackTrace(Throwable receiver, PrintStream stream) {
            receiver.printStackTrace(stream);
        }

        @Override
        public void printStackTrace(Throwable receiver, PrintWriter writer) {
            receiver.printStackTrace(writer);
        }
    }

    static abstract class AbstractDesugaringStrategy {
        protected static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];

        AbstractDesugaringStrategy() {
        }

        public abstract void addSuppressed(Throwable var1, Throwable var2);

        public abstract Throwable[] getSuppressed(Throwable var1);

        public abstract void printStackTrace(Throwable var1);

        public abstract void printStackTrace(Throwable var1, PrintStream var2);

        public abstract void printStackTrace(Throwable var1, PrintWriter var2);
    }
}

