/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.internal.events.client.OrchestratedInstrumentationListener;
import androidx.test.internal.events.client.TestDiscovery;
import androidx.test.internal.events.client.TestDiscoveryEventService;
import androidx.test.internal.events.client.TestDiscoveryEventServiceConnection;
import androidx.test.internal.events.client.TestEventClientArgs;
import androidx.test.internal.events.client.TestEventClientConnectListener;
import androidx.test.internal.events.client.TestEventClientException;
import androidx.test.internal.events.client.TestEventServiceConnection;
import androidx.test.internal.events.client.TestRunEventService;
import androidx.test.internal.events.client.TestRunEventServiceConnection;
import androidx.test.internal.util.Checks;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public final class TestEventClient {
    private static final String TAG = "TestEventClient";
    public static final TestEventClient NO_OP_CLIENT = new TestEventClient();
    @Nullable
    private final TestDiscovery testDiscovery;
    @Nullable
    private final OrchestratedInstrumentationListener notificationRunListener;

    private TestEventClient() {
        this.testDiscovery = null;
        this.notificationRunListener = null;
    }

    private TestEventClient(@NonNull TestDiscovery testDiscovery) {
        Checks.checkNotNull((Object)testDiscovery, (Object)"testDiscovery cannot be null");
        this.testDiscovery = testDiscovery;
        this.notificationRunListener = null;
    }

    private TestEventClient(@NonNull OrchestratedInstrumentationListener runListener) {
        Checks.checkNotNull((Object)((Object)runListener), (Object)"runListener cannot be null");
        this.testDiscovery = null;
        this.notificationRunListener = runListener;
    }

    public static TestEventClient connect(@NonNull Context context, @NonNull TestEventClientConnectListener listener, @NonNull TestEventClientArgs args) {
        Checks.checkNotNull((Object)context, (Object)"context parameter cannot be null!");
        Checks.checkNotNull((Object)listener, (Object)"listener parameter cannot be null!");
        Checks.checkNotNull((Object)args, (Object)"args parameter cannot be null!");
        if (!args.isOrchestrated) {
            return NO_OP_CLIENT;
        }
        if (!args.isPrimaryInstrProcess) {
            Log.w((String)TAG, (String)"Orchestration requested, but this isn't the primary instrumentation");
            return NO_OP_CLIENT;
        }
        TestEventServiceConnection connection = TestEventClient.getConnection(listener, args);
        TestEventClient result = NO_OP_CLIENT;
        if (args.isTestDiscoveryRequested) {
            Log.v((String)TAG, (String)"Test discovery events requested");
            TestDiscoveryEventService testDiscoveryEventService = (TestDiscoveryEventService)((Object)connection);
            TestDiscovery testDiscovery = new TestDiscovery(testDiscoveryEventService);
            result = new TestEventClient(testDiscovery);
        } else if (args.isTestRunEventsRequested) {
            Log.v((String)TAG, (String)"Test run events requested");
            TestRunEventService notificationService = (TestRunEventService)((Object)connection);
            OrchestratedInstrumentationListener runListener = new OrchestratedInstrumentationListener(notificationService);
            result = new TestEventClient(runListener);
        }
        connection.connect(context);
        return result;
    }

    public boolean isTestDiscoveryEnabled() {
        return this.testDiscovery != null;
    }

    public boolean isTestRunEventsEnabled() {
        return this.notificationRunListener != null;
    }

    @Nullable
    public RunListener getNotificationRunListener() {
        if (!this.isTestRunEventsEnabled()) {
            Log.e((String)TAG, (String)"Orchestrator service not connected - can't send test run notifications");
        }
        return this.notificationRunListener;
    }

    public void addTests(@NonNull Description description) {
        if (!this.isTestDiscoveryEnabled()) {
            Log.e((String)TAG, (String)"Orchestrator service not connected - can't send tests");
            return;
        }
        try {
            this.testDiscovery.addTests(description);
        }
        catch (TestEventClientException e) {
            String string = String.valueOf(description);
            Log.e((String)TAG, (String)new StringBuilder(21 + String.valueOf(string).length()).append("Failed to add test [").append(string).append("]").toString(), (Throwable)e);
        }
    }

    @NonNull
    private static TestEventServiceConnection getConnection(@NonNull TestEventClientConnectListener listener, @NonNull TestEventClientArgs args) {
        if (args.orchestratorVersion == 1) {
            if (args.connectionFactory != null) {
                return args.connectionFactory.create(listener);
            }
            throw new IllegalArgumentException("Orchestrator v1 connectionFactory must be provided by TestEventClientArgs.Builder#setConnectionFactory()");
        }
        if (args.orchestratorVersion == 2) {
            if (args.isTestDiscoveryRequested) {
                return new TestDiscoveryEventServiceConnection((String)Checks.checkNotNull((Object)args.testDiscoveryService), listener);
            }
            if (args.isTestRunEventsRequested) {
                return new TestRunEventServiceConnection((String)Checks.checkNotNull((Object)args.testRunEventService), listener);
            }
        }
        throw new IllegalArgumentException("TestEventClientArgs misconfiguration - can't determine which service connection to use.");
    }

    public void reportProcessCrash(Throwable t, long timeoutMillis) {
        if (this.isTestRunEventsEnabled()) {
            this.notificationRunListener.reportProcessCrash(t, timeoutMillis);
        }
    }
}

