/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.events.client.TestEventClientConnectListener;
import androidx.test.internal.events.client.TestEventServiceConnection;
import androidx.test.internal.util.Checks;

public class TestEventServiceConnectionBase<T extends IInterface>
implements TestEventServiceConnection {
    private static final String TAG = "ConnectionBase";
    @NonNull
    private final TestEventClientConnectListener listener;
    @NonNull
    private final ServiceFromBinder<T> serviceFromBinder;
    @NonNull
    private final String serviceName;
    @Nullable
    private final String servicePackageName;
    @Nullable
    public T service = null;
    private final ServiceConnection connection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder binder) {
            TestEventServiceConnectionBase.this.service = TestEventServiceConnectionBase.this.serviceFromBinder.asInterface(binder);
            String string = String.valueOf(TestEventServiceConnectionBase.this.serviceName);
            Log.d((String)TestEventServiceConnectionBase.TAG, (String)(string.length() != 0 ? "Connected to ".concat(string) : new String("Connected to ")));
            TestEventServiceConnectionBase.this.listener.onTestEventClientConnect();
        }

        public void onServiceDisconnected(ComponentName className) {
            TestEventServiceConnectionBase.this.service = null;
            String string = String.valueOf(TestEventServiceConnectionBase.this.serviceName);
            Log.d((String)TestEventServiceConnectionBase.TAG, (String)(string.length() != 0 ? "Disconnected from ".concat(string) : new String("Disconnected from ")));
        }
    };

    public TestEventServiceConnectionBase(@NonNull String serviceName, @NonNull ServiceFromBinder<T> serviceFromBinder, @NonNull TestEventClientConnectListener listener) {
        this.serviceName = (String)Checks.checkNotNull((Object)TestEventServiceConnectionBase.getServiceNameOnly(serviceName), (Object)"serviceName cannot be null");
        this.servicePackageName = (String)Checks.checkNotNull((Object)TestEventServiceConnectionBase.getServicePackage(serviceName), (Object)"servicePackageName cannot be null");
        this.listener = (TestEventClientConnectListener)Checks.checkNotNull((Object)listener, (Object)"listener cannot be null");
        this.serviceFromBinder = (ServiceFromBinder)Checks.checkNotNull(serviceFromBinder, (Object)"serviceFromBinder cannot be null");
    }

    @Override
    public void connect(@NonNull Context context) {
        Intent intent = new Intent(this.serviceName);
        intent.setPackage(this.servicePackageName);
        if (!context.bindService(intent, this.connection, 1)) {
            String string = String.valueOf(this.serviceName);
            throw new IllegalStateException(string.length() != 0 ? "Cannot connect to ".concat(string) : new String("Cannot connect to "));
        }
    }

    @NonNull
    @VisibleForTesting
    static String getServiceNameOnly(@NonNull String serviceName) {
        String[] parts = serviceName.split("/");
        if (parts.length == 2) {
            String string;
            if (parts[1].startsWith(".")) {
                String string2 = String.valueOf(parts[0]);
                String string3 = String.valueOf(parts[1]);
                string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            } else {
                string = parts[1];
            }
            return string;
        }
        if (parts.length == 1) {
            return parts[0];
        }
        throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(serviceName).length()).append("Invalid serviceName [").append(serviceName).append("]").toString());
    }

    @Nullable
    @VisibleForTesting
    static String getServicePackage(@NonNull String serviceName) {
        String[] parts = serviceName.split("/");
        return parts.length >= 2 ? parts[0] : null;
    }

    public static interface ServiceFromBinder<T extends IInterface> {
        public T asInterface(IBinder var1);
    }
}

