/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner;

import android.app.Instrumentation;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.events.client.TestEventClient;
import androidx.test.internal.events.client.TestEventClientArgs;
import androidx.test.internal.events.client.TestEventClientConnectListener;
import androidx.test.internal.runner.RunnerArgs;
import androidx.test.internal.runner.TestExecutor;
import androidx.test.internal.runner.TestRequestBuilder;
import androidx.test.internal.runner.listener.ActivityFinisherRunListener;
import androidx.test.internal.runner.listener.CoverageListener;
import androidx.test.internal.runner.listener.DelayInjector;
import androidx.test.internal.runner.listener.InstrumentationResultPrinter;
import androidx.test.internal.runner.listener.LogRunListener;
import androidx.test.internal.runner.listener.SuiteAssignmentPrinter;
import androidx.test.internal.runner.storage.RunnerFileIO;
import androidx.test.internal.runner.storage.RunnerIO;
import androidx.test.internal.runner.storage.RunnerTestStorageIO;
import androidx.test.internal.runner.tracker.AnalyticsBasedUsageTracker;
import androidx.test.internal.util.ReflectionUtil;
import androidx.test.runner.AndroidJUnitRunner$$Lambda$0;
import androidx.test.runner.MonitoringInstrumentation;
import androidx.test.runner.UsageTrackerFacilitator;
import androidx.test.runner.lifecycle.ApplicationLifecycleCallback;
import androidx.test.runner.lifecycle.ApplicationLifecycleMonitorRegistry;
import androidx.test.runner.screenshot.ScreenCaptureProcessor;
import androidx.test.runner.screenshot.Screenshot;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Request;
import org.junit.runner.notification.RunListener;

public class AndroidJUnitRunner
extends MonitoringInstrumentation
implements TestEventClientConnectListener {
    private static final String LOG_TAG = "AndroidJUnitRunner";
    private static final long MILLIS_TO_WAIT_FOR_TEST_FINISH = TimeUnit.SECONDS.toMillis(20L);
    private Bundle arguments;
    private InstrumentationResultPrinter instrumentationResultPrinter = new InstrumentationResultPrinter();
    private RunnerArgs runnerArgs;
    private UsageTrackerFacilitator usageTrackerFacilitator;
    private TestEventClient testEventClient = TestEventClient.NO_OP_CLIENT;
    private RunnerIO runnerIO = new RunnerFileIO();

    public void onCreate(Bundle arguments) {
        super.onCreate(arguments);
        this.arguments = arguments;
        this.parseRunnerArgs(this.arguments);
        if (this.waitForDebugger(this.runnerArgs)) {
            Log.i((String)LOG_TAG, (String)"Waiting for debugger to connect...");
            Debug.waitForDebugger();
            Log.i((String)LOG_TAG, (String)"Debugger connected.");
        }
        this.usageTrackerFacilitator = this.isPrimaryInstrProcess(this.runnerArgs.targetProcess) ? new UsageTrackerFacilitator(this.runnerArgs) : new UsageTrackerFacilitator(false);
        for (ApplicationLifecycleCallback listener : this.runnerArgs.appListeners) {
            ApplicationLifecycleMonitorRegistry.getInstance().addLifecycleCallback(listener);
        }
        this.addScreenCaptureProcessors(this.runnerArgs);
        if (this.isOrchestratorServiceProvided()) {
            Log.v((String)LOG_TAG, (String)"Waiting to connect to the Orchestrator service...");
        } else {
            this.start();
        }
    }

    private boolean isOrchestratorServiceProvided() {
        TestEventClientArgs args = TestEventClientArgs.builder().setConnectionFactory(AndroidJUnitRunner$$Lambda$0.$instance).setOrchestratorService(this.runnerArgs.orchestratorService).setPrimaryInstProcess(this.isPrimaryInstrProcess(this.runnerArgs.targetProcess)).setTestDiscoveryRequested(this.runnerArgs.listTestsForOrchestrator).setTestRunEventsRequested(!this.runnerArgs.listTestsForOrchestrator).setTestDiscoveryService(this.runnerArgs.testDiscoveryService).setTestRunEventService(this.runnerArgs.testRunEventsService).build();
        this.testEventClient = TestEventClient.connect(this.getContext(), this, args);
        return this.testEventClient.isTestDiscoveryEnabled() || this.testEventClient.isTestRunEventsEnabled();
    }

    private boolean waitForDebugger(RunnerArgs arguments) {
        return arguments.debug && !arguments.listTestsForOrchestrator;
    }

    @Deprecated
    public void onOrchestratorConnect() {
        this.onTestEventClientConnect();
    }

    @Override
    public void onTestEventClientConnect() {
        this.start();
    }

    private void parseRunnerArgs(Bundle arguments) {
        this.runnerArgs = new RunnerArgs.Builder().fromManifest((Instrumentation)this).fromBundle((Instrumentation)this, arguments).build();
    }

    private Bundle getArguments() {
        return this.arguments;
    }

    @VisibleForTesting
    InstrumentationResultPrinter getInstrumentationResultPrinter() {
        return this.instrumentationResultPrinter;
    }

    public void onStart() {
        this.setJsBridgeClassName("androidx.test.espresso.web.bridge.JavaScriptBridge");
        super.onStart();
        Request testRequest = this.buildRequest(this.runnerArgs, this.getArguments());
        if (this.testEventClient.isTestDiscoveryEnabled()) {
            this.testEventClient.addTests(testRequest.getRunner().getDescription());
            this.finish(-1, new Bundle());
            return;
        }
        if (this.runnerArgs.remoteMethod != null) {
            ReflectionUtil.reflectivelyInvokeRemoteMethod((String)this.runnerArgs.remoteMethod.testClassName, (String)this.runnerArgs.remoteMethod.methodName);
        }
        if (!this.isPrimaryInstrProcess(this.runnerArgs.targetProcess)) {
            Log.i((String)LOG_TAG, (String)"Runner is idle...");
            return;
        }
        if (this.runnerArgs.useTestStorageService) {
            this.runnerIO = new RunnerTestStorageIO();
        }
        Bundle results = new Bundle();
        try {
            TestExecutor.Builder executorBuilder = new TestExecutor.Builder((Instrumentation)this);
            this.addListeners(this.runnerArgs, executorBuilder);
            results = executorBuilder.build().execute(testRequest);
        }
        catch (RuntimeException e) {
            String msg = "Fatal exception when running tests";
            Log.e((String)LOG_TAG, (String)"Fatal exception when running tests", (Throwable)e);
            String string = String.valueOf("Fatal exception when running tests\n");
            String string2 = String.valueOf(Log.getStackTraceString((Throwable)e));
            results.putString("stream", string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        this.finish(-1, results);
    }

    public void finish(int resultCode, Bundle results) {
        try {
            this.usageTrackerFacilitator.trackUsage(LOG_TAG, "1.4.0-alpha04");
            this.usageTrackerFacilitator.sendUsages();
        }
        catch (RuntimeException re) {
            Log.w((String)LOG_TAG, (String)"Failed to send analytics.", (Throwable)re);
        }
        super.finish(resultCode, results);
    }

    @VisibleForTesting
    final void addListeners(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.newRunListenerMode) {
            this.addListenersNewOrder(args, builder);
        } else {
            this.addListenersLegacyOrder(args, builder);
        }
    }

    private void addListenersLegacyOrder(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.logOnly) {
            builder.addRunListener(this.getInstrumentationResultPrinter());
        } else if (args.suiteAssignment) {
            builder.addRunListener(new SuiteAssignmentPrinter());
        } else {
            builder.addRunListener(new LogRunListener());
            if (this.testEventClient.isTestRunEventsEnabled()) {
                builder.addRunListener(this.testEventClient.getNotificationRunListener());
            } else {
                builder.addRunListener(this.getInstrumentationResultPrinter());
            }
            if (this.shouldWaitForActivitiesToComplete()) {
                builder.addRunListener(new ActivityFinisherRunListener((Instrumentation)this, new MonitoringInstrumentation.ActivityFinisher((MonitoringInstrumentation)this), new Runnable(){

                    @Override
                    public void run() {
                        AndroidJUnitRunner.this.waitForActivitiesToComplete();
                    }
                }));
            }
            this.addDelayListener(args, builder);
            this.addCoverageListener(args, builder);
        }
        AndroidJUnitRunner.addListenersFromClasspath(builder);
        this.addListenersFromArg(args, builder);
    }

    private void addListenersNewOrder(RunnerArgs args, TestExecutor.Builder builder) {
        AndroidJUnitRunner.addListenersFromClasspath(builder);
        this.addListenersFromArg(args, builder);
        if (args.logOnly) {
            builder.addRunListener(this.getInstrumentationResultPrinter());
        } else if (args.suiteAssignment) {
            builder.addRunListener(new SuiteAssignmentPrinter());
        } else {
            builder.addRunListener(new LogRunListener());
            this.addDelayListener(args, builder);
            this.addCoverageListener(args, builder);
            if (this.testEventClient.isTestRunEventsEnabled()) {
                builder.addRunListener(this.testEventClient.getNotificationRunListener());
            } else {
                builder.addRunListener(this.getInstrumentationResultPrinter());
            }
            if (this.shouldWaitForActivitiesToComplete()) {
                builder.addRunListener(new ActivityFinisherRunListener((Instrumentation)this, new MonitoringInstrumentation.ActivityFinisher((MonitoringInstrumentation)this), new Runnable(){

                    @Override
                    public void run() {
                        AndroidJUnitRunner.this.waitForActivitiesToComplete();
                    }
                }));
            }
        }
    }

    private void addScreenCaptureProcessors(RunnerArgs args) {
        Screenshot.addScreenCaptureProcessors(new HashSet<ScreenCaptureProcessor>(args.screenCaptureProcessors));
    }

    private void addCoverageListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.codeCoverage) {
            builder.addRunListener(new CoverageListener(args.codeCoveragePath, this.runnerIO));
        }
    }

    private void addDelayListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.delayInMillis > 0) {
            builder.addRunListener(new DelayInjector(args.delayInMillis));
        } else if (args.logOnly && Build.VERSION.SDK_INT < 16) {
            builder.addRunListener(new DelayInjector(15));
        }
    }

    private static void addListenersFromClasspath(TestExecutor.Builder builder) {
        for (RunListener listener : ServiceLoader.load(RunListener.class)) {
            builder.addRunListener(listener);
        }
    }

    private void addListenersFromArg(RunnerArgs args, TestExecutor.Builder builder) {
        for (RunListener listener : args.listeners) {
            builder.addRunListener(listener);
        }
    }

    public boolean onException(Object obj, Throwable e) {
        Log.e((String)LOG_TAG, (String)"An unhandled exception was thrown by the app.");
        InstrumentationResultPrinter instResultPrinter = this.getInstrumentationResultPrinter();
        if (instResultPrinter != null) {
            instResultPrinter.reportProcessCrash(e);
        }
        if (this.testEventClient.isTestRunEventsEnabled()) {
            this.testEventClient.reportProcessCrash(e, MILLIS_TO_WAIT_FOR_TEST_FINISH);
        }
        Log.i((String)LOG_TAG, (String)"Bringing down the entire Instrumentation process.");
        return super.onException(obj, e);
    }

    @VisibleForTesting
    Request buildRequest(RunnerArgs runnerArgs, Bundle bundleArgs) {
        TestRequestBuilder builder = this.createTestRequestBuilder((Instrumentation)this, bundleArgs);
        builder.addPathsToScan(runnerArgs.classpathToScan);
        if (runnerArgs.classpathToScan.isEmpty()) {
            builder.addPathToScan(this.getContext().getPackageCodePath());
        }
        builder.addFromRunnerArgs(runnerArgs);
        this.registerUserTracker();
        return builder.build();
    }

    private void registerUserTracker() {
        Context targetContext = this.getTargetContext();
        if (targetContext != null) {
            this.usageTrackerFacilitator.registerUsageTracker(new AnalyticsBasedUsageTracker.Builder(targetContext).buildIfPossible());
        }
    }

    TestRequestBuilder createTestRequestBuilder(Instrumentation instr, Bundle arguments) {
        return new TestRequestBuilder(instr, arguments);
    }
}

