/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package androidx.test.runner.screenshot;

import android.graphics.Bitmap;
import androidx.annotation.VisibleForTesting;
import androidx.test.InstrumentationRegistry;

/**
 * Wrapper for UiAutomation object.
 *
 * <p>Ideally we wouldn't need this abstraction but since {@link android.app.UiAutomation} is final
 * we need an abstraction on top to be able to mock it in tests.
 */
public class UiAutomationWrapper {

  @VisibleForTesting
  UiAutomationWrapper() {}

  public Bitmap takeScreenshot() {
    return InstrumentationRegistry.getInstrumentation().getUiAutomation().takeScreenshot();
  }
}
