/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import androidx.annotation.VisibleForTesting;
import androidx.test.filters.LargeTest;
import androidx.test.filters.MediumTest;
import androidx.test.filters.SmallTest;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.runner.Description;

public final class TestSize {
    public static final TestSize SMALL = new TestSize("small", SmallTest.class, "android.test.suitebuilder.annotation.SmallTest", 200.0f);
    public static final TestSize MEDIUM = new TestSize("medium", MediumTest.class, "android.test.suitebuilder.annotation.MediumTest", 1000.0f);
    public static final TestSize LARGE = new TestSize("large", LargeTest.class, "android.test.suitebuilder.annotation.LargeTest", Float.MAX_VALUE);
    public static final TestSize NONE = new TestSize("", null, null, 0.0f);
    private static final Set<TestSize> ALL_SIZES = Collections.unmodifiableSet(new HashSet<TestSize>(Arrays.asList(SMALL, MEDIUM, LARGE)));
    private final String sizeQualifierName;
    private final Class<? extends Annotation> platformAnnotationClass;
    private final Class<? extends Annotation> runnerFilterAnnotationClass;
    private final float testSizeRunTimeThreshold;

    @VisibleForTesting
    public TestSize(String sizeQualifierName, Class<? extends Annotation> runnerFilterAnnotationClass, String legacyPlatformAnnotationClassName, float testSizeRuntimeThreshold) {
        this.sizeQualifierName = sizeQualifierName;
        this.platformAnnotationClass = TestSize.loadPlatformAnnotationClass(legacyPlatformAnnotationClassName);
        this.runnerFilterAnnotationClass = runnerFilterAnnotationClass;
        this.testSizeRunTimeThreshold = testSizeRuntimeThreshold;
    }

    private static Class<? extends Annotation> loadPlatformAnnotationClass(String legacyPlatformAnnotationClassName) {
        if (legacyPlatformAnnotationClassName == null) {
            return null;
        }
        try {
            return Class.forName(legacyPlatformAnnotationClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getSizeQualifierName() {
        return this.sizeQualifierName;
    }

    public boolean testMethodIsAnnotatedWithTestSize(Description description) {
        return description.getAnnotation(this.runnerFilterAnnotationClass) != null || description.getAnnotation(this.platformAnnotationClass) != null;
    }

    public boolean testClassIsAnnotatedWithTestSize(Description description) {
        Class testClass = description.getTestClass();
        if (null == testClass) {
            return false;
        }
        return TestSize.hasAnnotation(testClass, this.runnerFilterAnnotationClass) || TestSize.hasAnnotation(testClass, this.platformAnnotationClass);
    }

    private static boolean hasAnnotation(Class<?> testClass, Class<? extends Annotation> annotationClass) {
        return annotationClass != null && testClass.isAnnotationPresent(annotationClass);
    }

    public float getRunTimeThreshold() {
        return this.testSizeRunTimeThreshold;
    }

    public static TestSize getTestSizeForRunTime(float testRuntime) {
        if (TestSize.runTimeSmallerThanThreshold(testRuntime, SMALL.getRunTimeThreshold())) {
            return SMALL;
        }
        if (TestSize.runTimeSmallerThanThreshold(testRuntime, MEDIUM.getRunTimeThreshold())) {
            return MEDIUM;
        }
        return LARGE;
    }

    public static boolean isAnyTestSize(Class<? extends Annotation> annotationClass) {
        for (TestSize testSize : ALL_SIZES) {
            if (testSize.getRunnerAnnotation() != annotationClass && testSize.getFrameworkAnnotation() != annotationClass) continue;
            return true;
        }
        return false;
    }

    public static TestSize fromString(String testSize) {
        TestSize testSizeFromString = NONE;
        for (TestSize testSizeValue : ALL_SIZES) {
            if (!testSizeValue.getSizeQualifierName().equals(testSize)) continue;
            testSizeFromString = testSizeValue;
        }
        return testSizeFromString;
    }

    public static TestSize fromDescription(Description description) {
        TestSize testSize = NONE;
        for (TestSize testMethodSizeValue : ALL_SIZES) {
            if (!testMethodSizeValue.testMethodIsAnnotatedWithTestSize(description)) continue;
            testSize = testMethodSizeValue;
            break;
        }
        if (NONE.equals(testSize)) {
            for (TestSize testClassSizeValue : ALL_SIZES) {
                if (!testClassSizeValue.testClassIsAnnotatedWithTestSize(description)) continue;
                testSize = testClassSizeValue;
                break;
            }
        }
        return testSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestSize testSize = (TestSize)o;
        return this.sizeQualifierName.equals(testSize.sizeQualifierName);
    }

    public int hashCode() {
        return this.sizeQualifierName.hashCode();
    }

    private static boolean runTimeSmallerThanThreshold(float testRuntime, float runtimeThreshold) {
        return Float.compare(testRuntime, runtimeThreshold) < 0;
    }

    private Class<? extends Annotation> getFrameworkAnnotation() {
        return this.platformAnnotationClass;
    }

    private Class<? extends Annotation> getRunnerAnnotation() {
        return this.runnerFilterAnnotationClass;
    }
}

