/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.permission;

import android.annotation.TargetApi;
import android.app.UiAutomation;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.InstrumentationRegistry;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.internal.util.Checks;
import androidx.test.runner.permission.ShellCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@TargetApi(value=23)
@ExperimentalTestApi
class UiAutomationShellCommand
extends ShellCommand {
    private static final String TAG = "UiAutomationShellCmd";
    private final String targetPackage;
    private final String permission;
    private final PmCommand command;
    private final UiAutomation uiAutomation;

    UiAutomationShellCommand(String targetPackage, String permission, PmCommand pmCommand) {
        this.targetPackage = UiAutomationShellCommand.shellEscape(targetPackage);
        this.permission = UiAutomationShellCommand.shellEscape(permission);
        this.command = pmCommand;
        this.uiAutomation = (UiAutomation)Checks.checkNotNull((Object)InstrumentationRegistry.getInstrumentation().getUiAutomation());
    }

    @Override
    public void execute() throws Exception {
        this.executePermissionCommand(this.commandForPermission());
    }

    @VisibleForTesting
    protected String commandForPermission() {
        return this.command.get() + " " + this.targetPackage + " " + this.permission;
    }

    private void executePermissionCommand(String cmd) throws IOException {
        String string = String.valueOf(cmd);
        Log.i((String)TAG, (String)(string.length() != 0 ? "Requesting permission: ".concat(string) : new String("Requesting permission: ")));
        try {
            UiAutomationShellCommand.awaitTermination(this.uiAutomation.executeShellCommand(cmd), 2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            String string2 = String.valueOf(cmd);
            Log.e((String)TAG, (String)(string2.length() != 0 ? "Timeout while executing cmd: ".concat(string2) : new String("Timeout while executing cmd: ")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void awaitTermination(ParcelFileDescriptor pfDescriptor, long timeout, TimeUnit unit) throws IOException, TimeoutException {
        long timeoutInMillis = unit.toMillis(timeout);
        long endTimeInMillis = timeoutInMillis > 0L ? System.currentTimeMillis() + timeoutInMillis : 0L;
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(pfDescriptor)));
            while ((line = reader.readLine()) != null) {
                Log.i((String)TAG, (String)line);
                if (endTimeInMillis <= System.currentTimeMillis()) continue;
                throw new TimeoutException();
            }
        }
    }

    static enum PmCommand {
        GRANT_PERMISSION("grant");

        private final String pmCommand;

        private PmCommand(String command) {
            String string2 = String.valueOf(command);
            this.pmCommand = string2.length() != 0 ? "pm ".concat(string2) : new String("pm ");
        }

        public String get() {
            return this.pmCommand;
        }
    }
}

