/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.platform;

import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.TestRunInfo;
import androidx.test.services.events.TestStatus;
import androidx.test.services.events.TimeStamp;
import androidx.test.services.events.platform.TestPlatformEvent;

public class TestRunFinishedEvent
extends TestPlatformEvent {
    public final TestRunInfo testRun;
    public final TestStatus runStatus;
    public final TimeStamp timeStamp;

    public TestRunFinishedEvent(@NonNull TestRunInfo testRun, @NonNull TestStatus runStatus, @NonNull TimeStamp timeStamp) {
        this.testRun = (TestRunInfo)Checks.checkNotNull((Object)testRun, (Object)"testRun cannot be null");
        this.runStatus = (TestStatus)Checks.checkNotNull((Object)runStatus, (Object)"runStatus cannot be null");
        this.timeStamp = (TimeStamp)Checks.checkNotNull((Object)timeStamp, (Object)"timeStamp cannot be null");
    }

    TestRunFinishedEvent(Parcel source) {
        this.testRun = new TestRunInfo(source);
        this.runStatus = new TestStatus(source);
        this.timeStamp = new TimeStamp(source);
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        this.testRun.writeToParcel(parcel, i);
        this.runStatus.writeToParcel(parcel, i);
        this.timeStamp.writeToParcel(parcel, i);
    }

    @Override
    TestPlatformEvent.EventType instanceType() {
        return TestPlatformEvent.EventType.TEST_RUN_FINISHED;
    }
}

