/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.os.ConditionVariable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.internal.events.client.JUnitValidator;
import androidx.test.internal.events.client.TestRunEventService;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.FailureInfo;
import androidx.test.services.events.ParcelableConverter;
import androidx.test.services.events.TestCaseInfo;
import androidx.test.services.events.TestEventException;
import androidx.test.services.events.run.TestAssumptionFailureEvent;
import androidx.test.services.events.run.TestFailureEvent;
import androidx.test.services.events.run.TestFinishedEvent;
import androidx.test.services.events.run.TestIgnoredEvent;
import androidx.test.services.events.run.TestRunFinishedEvent;
import androidx.test.services.events.run.TestRunStartedEvent;
import androidx.test.services.events.run.TestStartedEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class OrchestratedInstrumentationListener
extends RunListener {
    private static final String TAG = "OrchestrationListener";
    private final TestRunEventService notificationService;
    private final ConditionVariable testFinishedCondition = new ConditionVariable();
    private final AtomicBoolean isTestFailed = new AtomicBoolean(false);
    private Description description = Description.EMPTY;

    @Nullable
    private TestFailureEvent getTestFailureEventFromCachedDescription(@NonNull Failure failure) {
        TestCaseInfo testCase;
        Checks.checkNotNull((Object)failure, (Object)"failure cannot be null");
        try {
            testCase = ParcelableConverter.getTestCaseFromDescription(this.description);
        }
        catch (TestEventException ex) {
            String string = String.valueOf(this.description);
            Log.e((String)TAG, (String)new StringBuilder(49 + String.valueOf(string).length()).append("Unable to determine test case from description [").append(string).append("]").toString(), (Throwable)ex);
            return null;
        }
        return new TestFailureEvent(testCase, new FailureInfo(failure.getMessage(), failure.getTestHeader(), failure.getTrace(), testCase));
    }

    public OrchestratedInstrumentationListener(@NonNull TestRunEventService notificationService) {
        Checks.checkNotNull((Object)notificationService, (Object)"notificationService cannot be null");
        this.notificationService = notificationService;
    }

    private void reportProcessCrash(Throwable t) {
        this.testFailure(new Failure(this.description, t));
        this.testFinished(this.description);
    }

    public void testAssumptionFailure(Failure failure) {
        try {
            this.notificationService.send(new TestAssumptionFailureEvent(ParcelableConverter.getTestCaseFromDescription(failure.getDescription()), ParcelableConverter.getFailure(failure)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestAssumptionFailureEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testFailure(Failure failure) {
        if (this.isTestFailed.compareAndSet(false, true)) {
            TestFailureEvent event;
            block6: {
                Description description = failure.getDescription();
                if (!JUnitValidator.validateDescription(description)) {
                    String string = description.getClassName();
                    String string2 = description.getMethodName();
                    Log.w((String)TAG, (String)new StringBuilder(51 + String.valueOf(string).length() + String.valueOf(string2).length()).append("testFailure: JUnit reported ").append(string).append("#").append(string2).append("; discarding as bogus.").toString());
                    return;
                }
                try {
                    event = new TestFailureEvent(ParcelableConverter.getTestCaseFromDescription(failure.getDescription()), ParcelableConverter.getFailure(failure));
                }
                catch (TestEventException e) {
                    String string = String.valueOf(failure);
                    Log.d((String)TAG, (String)new StringBuilder(45 + String.valueOf(string).length()).append("Unable to determine test case from failure [").append(string).append("]").toString(), (Throwable)e);
                    event = this.getTestFailureEventFromCachedDescription(failure);
                    if (event != null) break block6;
                    return;
                }
            }
            try {
                this.notificationService.send(event);
            }
            catch (TestEventException e) {
                throw new IllegalStateException("Unable to send TestFailureEvent, terminating", e);
            }
        }
    }

    public void testFinished(Description description) {
        if (!JUnitValidator.validateDescription(description)) {
            String string = description.getClassName();
            String string2 = description.getMethodName();
            Log.w((String)TAG, (String)new StringBuilder(52 + String.valueOf(string).length() + String.valueOf(string2).length()).append("testFinished: JUnit reported ").append(string).append("#").append(string2).append("; discarding as bogus.").toString());
            return;
        }
        try {
            this.notificationService.send(new TestFinishedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestFinishedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testIgnored(Description description) {
        try {
            TestCaseInfo info = ParcelableConverter.getTestCaseFromDescription(description);
            String string = description.getDisplayName();
            String string2 = description.getClassName();
            String string3 = description.getMethodName();
            String string4 = info.getClassAndMethodName();
            Log.i((String)TAG, (String)new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("TestIgnoredEvent(").append(string).append("): ").append(string2).append("#").append(string3).append(" = ").append(string4).toString());
            this.notificationService.send(new TestIgnoredEvent(info));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestIgnoredEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testRunFinished(Result result) {
        List<FailureInfo> failures = Collections.emptyList();
        try {
            failures = ParcelableConverter.getFailuresFromList(result.getFailures());
        }
        catch (TestEventException e) {
            Log.w((String)TAG, (String)"Failure event doesn't contain a test case", (Throwable)e);
        }
        try {
            this.notificationService.send(new TestRunFinishedEvent(result.getRunCount(), result.getIgnoreCount(), result.getRunTime(), failures));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunFinishedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testRunStarted(Description description) {
        try {
            this.notificationService.send(new TestRunStartedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunStartedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testStarted(Description description) {
        this.description = description;
        if (!JUnitValidator.validateDescription(description)) {
            String string = description.getClassName();
            String string2 = description.getMethodName();
            Log.w((String)TAG, (String)new StringBuilder(51 + String.valueOf(string).length() + String.valueOf(string2).length()).append("testStarted: JUnit reported ").append(string).append("#").append(string2).append("; discarding as bogus.").toString());
            return;
        }
        try {
            this.notificationService.send(new TestStartedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestStartedEvent to Orchestrator", (Throwable)e);
        }
    }

    private void waitUntilTestFinished(long timeoutMillis) {
        if (!this.testFinishedCondition.block(timeoutMillis)) {
            Log.w((String)TAG, (String)"Timeout waiting for the test to finish");
        }
    }

    public boolean reportProcessCrash(Throwable t, long timeoutMillis) {
        this.waitUntilTestFinished(timeoutMillis);
        if (!this.isTestFailed.get()) {
            Log.i((String)TAG, (String)"No test failure has been reported. Report the process crash.");
            this.reportProcessCrash(t);
            return true;
        }
        return false;
    }
}

