/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.app.Instrumentation;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.filters.RequiresDevice;
import androidx.test.filters.SdkSuppress;
import androidx.test.filters.Suppress;
import androidx.test.internal.runner.AndroidLogOnlyBuilder;
import androidx.test.internal.runner.AndroidRunnerBuilder;
import androidx.test.internal.runner.ClassPathScanner;
import androidx.test.internal.runner.RunnerArgs;
import androidx.test.internal.runner.TestLoader;
import androidx.test.internal.runner.TestSize;
import androidx.test.internal.runner.filters.ParentFilter;
import androidx.test.internal.runner.filters.TestsRegExFilter;
import androidx.test.internal.util.AndroidRunnerParams;
import androidx.test.internal.util.Checks;
import androidx.tracing.Trace;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TestRequestBuilder {
    private static final String TAG = "TestRequestBuilder";
    static final String MISSING_ARGUMENTS_MSG = "Must provide either classes to run, or paths to scan";
    static final String AMBIGUOUS_ARGUMENTS_MSG = "Ambiguous arguments: cannot provide both test package and test class(es) to run";
    private final List<String> pathsToScan = new ArrayList<String>();
    private Set<String> includedPackages = new HashSet<String>();
    private Set<String> excludedPackages = new HashSet<String>();
    private Set<String> includedClasses = new HashSet<String>();
    private Set<String> excludedClasses = new HashSet<String>();
    private ClassAndMethodFilter classMethodFilter = new ClassAndMethodFilter();
    private final TestsRegExFilter testsRegExFilter = new TestsRegExFilter();
    private Filter filter = new AnnotationExclusionFilter(Suppress.class).intersect(new SdkSuppressFilter()).intersect((Filter)new RequiresDeviceFilter()).intersect((Filter)this.classMethodFilter).intersect((Filter)this.testsRegExFilter);
    private List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses = new ArrayList<Class<? extends RunnerBuilder>>();
    private boolean skipExecution = false;
    private final DeviceBuild deviceBuild;
    private long perTestTimeout = 0L;
    private final Instrumentation instr;
    private final Bundle argsBundle;
    private ClassLoader classLoader;
    private boolean ignoreSuiteMethods = false;

    private int getDeviceSdkInt() {
        return this.deviceBuild.getSdkVersionInt();
    }

    ClassPathScanner createClassPathScanner(List<String> classPath) {
        return new ClassPathScanner(classPath);
    }

    public TestRequestBuilder addAnnotationExclusionFilter(String notAnnotation) {
        Class<? extends Annotation> annotationClass = this.loadAnnotationClass(notAnnotation);
        if (annotationClass != null) {
            this.addFilter(new AnnotationExclusionFilter(annotationClass));
        }
        return this;
    }

    public TestRequestBuilder addAnnotationInclusionFilter(String annotation) {
        Class<? extends Annotation> annotationClass = this.loadAnnotationClass(annotation);
        if (annotationClass != null) {
            this.addFilter(new AnnotationInclusionFilter(annotationClass));
        }
        return this;
    }

    public TestRequestBuilder addCustomRunnerBuilderClass(Class<? extends RunnerBuilder> runnerBuilderClass) {
        this.customRunnerBuilderClasses.add(runnerBuilderClass);
        return this;
    }

    public TestRequestBuilder addFilter(Filter filter) {
        this.filter = this.filter.intersect(filter);
        return this;
    }

    public TestRequestBuilder addFromRunnerArgs(RunnerArgs runnerArgs) {
        for (RunnerArgs.TestArg testArg : runnerArgs.tests) {
            if (testArg.methodName == null) {
                this.addTestClass(testArg.testClassName);
                continue;
            }
            this.addTestMethod(testArg.testClassName, testArg.methodName);
        }
        for (RunnerArgs.TestArg testArg : runnerArgs.notTests) {
            if (testArg.methodName == null) {
                this.removeTestClass(testArg.testClassName);
                continue;
            }
            this.removeTestMethod(testArg.testClassName, testArg.methodName);
        }
        for (String string : runnerArgs.testPackages) {
            this.addTestPackage(string);
        }
        for (String string : runnerArgs.notTestPackages) {
            this.removeTestPackage(string);
        }
        if (runnerArgs.testSize != null) {
            this.addTestSizeFilter(TestSize.fromString(runnerArgs.testSize));
        }
        for (String string : runnerArgs.annotations) {
            this.addAnnotationInclusionFilter(string);
        }
        for (String string : runnerArgs.notAnnotations) {
            this.addAnnotationExclusionFilter(string);
        }
        for (Filter filter : runnerArgs.filters) {
            this.addFilter(filter);
        }
        if (runnerArgs.testTimeout > 0L) {
            this.setPerTestTimeout(runnerArgs.testTimeout);
        }
        if (runnerArgs.numShards > 0 && runnerArgs.shardIndex >= 0 && runnerArgs.shardIndex < runnerArgs.numShards) {
            this.addShardingFilter(runnerArgs.numShards, runnerArgs.shardIndex);
        }
        if (runnerArgs.logOnly || runnerArgs.listTestsForOrchestrator) {
            this.setSkipExecution(true);
        }
        if (runnerArgs.classLoader != null) {
            this.setClassLoader(runnerArgs.classLoader);
        }
        for (Class clazz : runnerArgs.runnerBuilderClasses) {
            this.addCustomRunnerBuilderClass(clazz);
        }
        if (runnerArgs.testsRegEx != null) {
            this.setTestsRegExFilter(runnerArgs.testsRegEx);
        }
        return this;
    }

    public TestRequestBuilder addPathToScan(String path) {
        this.pathsToScan.add(path);
        return this;
    }

    public TestRequestBuilder addPathsToScan(Iterable<String> paths) {
        for (String path : paths) {
            this.addPathToScan(path);
        }
        return this;
    }

    public TestRequestBuilder addShardingFilter(int numShards, int shardIndex) {
        return this.addFilter(new ShardingFilter(numShards, shardIndex));
    }

    public TestRequestBuilder addTestClass(String className) {
        this.includedClasses.add(className);
        return this;
    }

    public TestRequestBuilder addTestMethod(String testClassName, String testMethodName) {
        this.includedClasses.add(testClassName);
        this.classMethodFilter.addMethod(testClassName, testMethodName);
        return this;
    }

    public TestRequestBuilder addTestPackage(String testPackage) {
        this.includedPackages.add(testPackage);
        return this;
    }

    public TestRequestBuilder addTestSizeFilter(TestSize forTestSize) {
        if (!TestSize.NONE.equals(forTestSize)) {
            this.addFilter(new SizeFilter(forTestSize));
        } else {
            Log.e((String)TAG, (String)String.format("Unrecognized test size '%s'", forTestSize.getSizeQualifierName()));
        }
        return this;
    }

    public TestRequestBuilder ignoreSuiteMethods(boolean ignoreSuiteMethods) {
        this.ignoreSuiteMethods = ignoreSuiteMethods;
        return this;
    }

    public TestRequestBuilder removeTestClass(String className) {
        this.excludedClasses.add(className);
        return this;
    }

    public TestRequestBuilder removeTestMethod(String testClassName, String testMethodName) {
        this.classMethodFilter.removeMethod(testClassName, testMethodName);
        return this;
    }

    public TestRequestBuilder removeTestPackage(String testPackage) {
        this.excludedPackages.add(testPackage);
        return this;
    }

    public TestRequestBuilder setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
        return this;
    }

    public TestRequestBuilder setPerTestTimeout(long millis) {
        this.perTestTimeout = millis;
        return this;
    }

    public TestRequestBuilder setSkipExecution(boolean b) {
        this.skipExecution = b;
        return this;
    }

    public TestRequestBuilder setTestsRegExFilter(String testsRegex) {
        this.testsRegExFilter.setPattern(testsRegex);
        return this;
    }

    private Class<? extends Annotation> loadAnnotationClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)String.format("Could not find annotation class: %s", className));
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)String.format("Class %s is not an annotation", className));
        }
        return null;
    }

    private String getDeviceCodeName() {
        return this.deviceBuild.getCodeName();
    }

    private String getDeviceHardware() {
        return this.deviceBuild.getHardware();
    }

    private Collection<String> getClassNamesFromClassPath() {
        if (this.pathsToScan.isEmpty()) {
            throw new IllegalStateException("neither test class to execute or class paths were provided");
        }
        Log.i((String)TAG, (String)String.format("Scanning classpath to find tests in paths %s", this.pathsToScan));
        ClassPathScanner scanner = this.createClassPathScanner(this.pathsToScan);
        ClassPathScanner.ChainedClassNameFilter filter = new ClassPathScanner.ChainedClassNameFilter();
        filter.add(new ClassPathScanner.ExternalClassNameFilter());
        for (String pkg : ClassPathScanner.getDefaultExcludedPackages()) {
            if (this.includedPackages.contains(pkg)) continue;
            this.excludedPackages.add(pkg);
        }
        if (!this.includedPackages.isEmpty()) {
            filter.add(new ClassPathScanner.InclusivePackageNamesFilter(this.includedPackages));
        }
        for (String pkg : this.excludedPackages) {
            filter.add(new ClassPathScanner.ExcludePackageNameFilter(pkg));
        }
        filter.add(new ClassPathScanner.ExcludeClassNamesFilter(this.excludedClasses));
        try {
            return scanner.getClassPathEntries(filter);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to scan classes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request build() {
        Trace.beginSection((String)"build test request");
        try {
            Collection<String> classNames;
            this.includedPackages.removeAll(this.excludedPackages);
            this.includedClasses.removeAll(this.excludedClasses);
            this.validate(this.includedClasses);
            boolean scanningPath = this.includedClasses.isEmpty();
            boolean ignoreSuiteMethods = this.ignoreSuiteMethods || scanningPath;
            AndroidRunnerParams runnerParams = new AndroidRunnerParams(this.instr, this.argsBundle, this.perTestTimeout, ignoreSuiteMethods);
            RunnerBuilder runnerBuilder = this.getRunnerBuilder(runnerParams);
            TestLoader loader = TestLoader.Factory.create(this.classLoader, runnerBuilder, scanningPath);
            if (scanningPath) {
                Log.d((String)TAG, (String)"Using class path scanning to discover tests");
                classNames = this.getClassNamesFromClassPath();
            } else {
                Log.d((String)TAG, (String)String.format("Skipping class path scanning and directly running %s", this.includedClasses));
                classNames = this.includedClasses;
            }
            List<Runner> runners = loader.getRunnersFor(classNames);
            Suite suite = ExtendedSuite.createSuite(runners);
            Request request = Request.runner((Runner)suite);
            LenientFilterRequest lenientFilterRequest = new LenientFilterRequest(request, this.filter);
            return lenientFilterRequest;
        }
        finally {
            Trace.endSection();
        }
    }

    private RunnerBuilder getRunnerBuilder(AndroidRunnerParams runnerParams) {
        Object builder = this.skipExecution ? new AndroidLogOnlyBuilder(runnerParams, this.customRunnerBuilderClasses) : new AndroidRunnerBuilder(runnerParams, this.customRunnerBuilderClasses);
        return builder;
    }

    public TestRequestBuilder(Instrumentation instr, Bundle bundle) {
        this(new DeviceBuildImpl(), instr, bundle);
    }

    @VisibleForTesting
    TestRequestBuilder(DeviceBuild deviceBuildAccessor, Instrumentation instr, Bundle bundle) {
        this.deviceBuild = (DeviceBuild)Checks.checkNotNull((Object)deviceBuildAccessor);
        this.instr = (Instrumentation)Checks.checkNotNull((Object)instr);
        this.argsBundle = (Bundle)Checks.checkNotNull((Object)bundle);
        this.maybeAddLegacySuppressFilter();
    }

    private void maybeAddLegacySuppressFilter() {
        try {
            Class<?> legacySuppressClass = Class.forName("android.test.suitebuilder.annotation.Suppress");
            this.filter = this.filter.intersect((Filter)new AnnotationExclusionFilter(legacySuppressClass));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void validate(Set<String> classNames) {
        if (classNames.isEmpty() && this.pathsToScan.isEmpty()) {
            throw new IllegalArgumentException(MISSING_ARGUMENTS_MSG);
        }
    }

    private static class MethodFilter
    extends ParentFilter {
        private final String className;
        private Set<String> includedMethods = new HashSet<String>();
        private Set<String> excludedMethods = new HashSet<String>();

        public String describe() {
            String string = this.className;
            return new StringBuilder(24 + String.valueOf(string).length()).append("Method filter for ").append(string).append(" class").toString();
        }

        private String stripParameterizedSuffix(String name) {
            Pattern suffixPattern = Pattern.compile(".+(\\[[0-9]+\\])$");
            if (suffixPattern.matcher(name).matches()) {
                name = name.substring(0, name.lastIndexOf(91));
            }
            return name;
        }

        public MethodFilter(String className) {
            this.className = className;
        }

        public void addExclusionMethod(String methodName) {
            this.excludedMethods.add(methodName);
        }

        public void addInclusionMethod(String methodName) {
            this.includedMethods.add(methodName);
        }

        @Override
        public boolean evaluateTest(Description description) {
            String methodName = description.getMethodName();
            if (methodName == null) {
                return false;
            }
            String rootMethodName = this.stripParameterizedSuffix(methodName);
            if (this.excludedMethods.contains(methodName) || this.excludedMethods.contains(rootMethodName)) {
                return false;
            }
            return this.includedMethods.isEmpty() || this.includedMethods.contains(methodName) || this.includedMethods.contains(rootMethodName) || methodName.equals("initializationError");
        }
    }

    private static class ClassAndMethodFilter
    extends ParentFilter {
        private Map<String, MethodFilter> methodFilters = new HashMap<String, MethodFilter>();

        public String describe() {
            return "Class and method filter";
        }

        private ClassAndMethodFilter() {
        }

        public void addMethod(String className, String methodName) {
            MethodFilter methodFilter = this.methodFilters.get(className);
            if (methodFilter == null) {
                methodFilter = new MethodFilter(className);
                this.methodFilters.put(className, methodFilter);
            }
            methodFilter.addInclusionMethod(methodName);
        }

        public void removeMethod(String className, String methodName) {
            MethodFilter methodFilter = this.methodFilters.get(className);
            if (methodFilter == null) {
                methodFilter = new MethodFilter(className);
                this.methodFilters.put(className, methodFilter);
            }
            methodFilter.addExclusionMethod(methodName);
        }

        @Override
        public boolean evaluateTest(Description description) {
            if (this.methodFilters.isEmpty()) {
                return true;
            }
            String className = description.getClassName();
            MethodFilter methodFilter = this.methodFilters.get(className);
            if (methodFilter != null) {
                return methodFilter.shouldRun(description);
            }
            return true;
        }
    }

    private static class BlankRunner
    extends Runner {
        public Description getDescription() {
            return Description.createSuiteDescription((String)"no tests found", (Annotation[])new Annotation[0]);
        }

        private BlankRunner() {
        }

        public void run(RunNotifier notifier) {
        }
    }

    private static class LenientFilterRequest
    extends Request {
        private final Request request;
        private final Filter filter;

        public Runner getRunner() {
            try {
                Runner runner = this.request.getRunner();
                this.filter.apply((Object)runner);
                return runner;
            }
            catch (NoTestsRemainException e) {
                return new BlankRunner();
            }
        }

        public LenientFilterRequest(Request classRequest, Filter filter) {
            this.request = classRequest;
            this.filter = filter;
        }
    }

    private static class ShardingFilter
    extends Filter {
        private final int numShards;
        private final int shardIndex;

        public String describe() {
            return String.format("Shard %s of %s shards", this.shardIndex, this.numShards);
        }

        ShardingFilter(int numShards, int shardIndex) {
            this.numShards = numShards;
            this.shardIndex = shardIndex;
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                return Math.abs(description.hashCode()) % this.numShards == this.shardIndex;
            }
            return true;
        }
    }

    @VisibleForTesting
    class RequiresDeviceFilter
    extends AnnotationExclusionFilter {
        static final String EMULATOR_HARDWARE_GOLDFISH = "goldfish";
        static final String EMULATOR_HARDWARE_RANCHU = "ranchu";
        static final String EMULATOR_HARDWARE_GCE = "gce_x86";
        private final Set<String> emulatorHardwareNames;

        @Override
        public String describe() {
            return String.format("skip tests annotated with RequiresDevice if necessary", new Object[0]);
        }

        RequiresDeviceFilter() {
            super(RequiresDevice.class);
            this.emulatorHardwareNames = new HashSet<String>(Arrays.asList(EMULATOR_HARDWARE_GOLDFISH, EMULATOR_HARDWARE_RANCHU, EMULATOR_HARDWARE_GCE));
        }

        @Override
        protected boolean evaluateTest(Description description) {
            if (!super.evaluateTest(description)) {
                return !this.emulatorHardwareNames.contains(TestRequestBuilder.this.getDeviceHardware());
            }
            return true;
        }
    }

    private class SdkSuppressFilter
    extends ParentFilter {
        private SdkSuppress getAnnotationForTest(Description description) {
            SdkSuppress s = (SdkSuppress)description.getAnnotation(SdkSuppress.class);
            if (s != null) {
                return s;
            }
            Class testClass = description.getTestClass();
            if (testClass != null) {
                return testClass.getAnnotation(SdkSuppress.class);
            }
            return null;
        }

        public String describe() {
            return String.format("skip tests annotated with SdkSuppress if necessary", new Object[0]);
        }

        private SdkSuppressFilter() {
        }

        @Override
        protected boolean evaluateTest(Description description) {
            SdkSuppress sdkSuppress = this.getAnnotationForTest(description);
            if (sdkSuppress != null) {
                return TestRequestBuilder.this.getDeviceSdkInt() >= sdkSuppress.minSdkVersion() && TestRequestBuilder.this.getDeviceSdkInt() <= sdkSuppress.maxSdkVersion() || TestRequestBuilder.this.getDeviceCodeName().equals(sdkSuppress.codeName());
            }
            return true;
        }
    }

    private static class ExtendedSuite
    extends Suite {
        static Suite createSuite(List<Runner> runners) {
            try {
                return new ExtendedSuite(runners);
            }
            catch (InitializationError e) {
                String string = Suite.class.getName();
                throw new RuntimeException(new StringBuilder(107 + String.valueOf(string).length()).append("Internal Error: ").append(string).append("(Class<?>, List<Runner>) should never throw an InitializationError when passed a null Class").toString());
            }
        }

        ExtendedSuite(List<Runner> runners) throws InitializationError {
            super(null, runners);
        }
    }

    private static class AnnotationExclusionFilter
    extends ParentFilter {
        private final Class<? extends Annotation> annotationClass;

        public String describe() {
            return String.format("not annotation %s", this.annotationClass.getName());
        }

        AnnotationExclusionFilter(Class<? extends Annotation> annotation) {
            this.annotationClass = annotation;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            return (testClass == null || !testClass.isAnnotationPresent(this.annotationClass)) && description.getAnnotation(this.annotationClass) == null;
        }
    }

    private static class SizeFilter
    extends ParentFilter {
        private final TestSize testSize;

        public String describe() {
            return "";
        }

        SizeFilter(TestSize testSize) {
            this.testSize = testSize;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            if (this.testSize.testMethodIsAnnotatedWithTestSize(description)) {
                return true;
            }
            if (this.testSize.testClassIsAnnotatedWithTestSize(description)) {
                for (Annotation a : description.getAnnotations()) {
                    if (!TestSize.isAnyTestSize(a.annotationType())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class AnnotationInclusionFilter
    extends ParentFilter {
        private final Class<? extends Annotation> annotationClass;

        protected Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public String describe() {
            return String.format("annotation %s", this.annotationClass.getName());
        }

        AnnotationInclusionFilter(Class<? extends Annotation> annotation) {
            this.annotationClass = annotation;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            return description.getAnnotation(this.annotationClass) != null || testClass != null && testClass.isAnnotationPresent(this.annotationClass);
        }
    }

    private static class DeviceBuildImpl
    implements DeviceBuild {
        @Override
        public int getSdkVersionInt() {
            return Build.VERSION.SDK_INT;
        }

        @Override
        public String getCodeName() {
            return Build.VERSION.CODENAME;
        }

        @Override
        public String getHardware() {
            return Build.HARDWARE;
        }

        private DeviceBuildImpl() {
        }
    }

    static interface DeviceBuild {
        public int getSdkVersionInt();

        public String getCodeName();

        public String getHardware();
    }
}

