/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.callback;

import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.events.client.TestDiscoveryEventService;
import androidx.test.internal.events.client.TestEventClientConnectListener;
import androidx.test.internal.events.client.TestEventClientException;
import androidx.test.internal.events.client.TestEventServiceConnectionBase;
import androidx.test.internal.events.client.TestRunEventService;
import androidx.test.internal.util.Checks;
import androidx.test.orchestrator.callback.BundleConverter;
import androidx.test.orchestrator.callback.OrchestratorCallback;
import androidx.test.orchestrator.callback.OrchestratorV1Connection$$ExternalSyntheticLambda0;
import androidx.test.services.events.discovery.TestDiscoveryEvent;
import androidx.test.services.events.discovery.TestFoundEvent;
import androidx.test.services.events.run.TestRunEvent;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class OrchestratorV1Connection
extends TestEventServiceConnectionBase<OrchestratorCallback>
implements TestRunEventService,
TestDiscoveryEventService {
    private static final String ORCHESTRATOR_SERVICE = "androidx.test.orchestrator/.OrchestratorService";

    public OrchestratorV1Connection(@NonNull TestEventClientConnectListener listener) {
        super(ORCHESTRATOR_SERVICE, OrchestratorV1Connection$$ExternalSyntheticLambda0.INSTANCE, listener);
    }

    @Override
    public void send(@NonNull TestDiscoveryEvent event) throws TestEventClientException {
        Checks.checkNotNull((Object)event, (Object)"event cannot be null");
        if (null == this.service) {
            throw new TestEventClientException("Unable to add test, Orchestrator callback is null");
        }
        if (event instanceof TestFoundEvent) {
            String testName = ((TestFoundEvent)event).testCase.getClassAndMethodName();
            try {
                ((OrchestratorCallback)this.service).addTest(testName);
            }
            catch (RemoteException e) {
                throw new TestEventClientException(new StringBuilder(21 + String.valueOf(testName).length()).append("Failed to add test [").append(testName).append("]").toString(), e);
            }
        }
    }

    @Override
    public void send(@NonNull TestRunEvent event) throws TestEventClientException {
        Checks.checkNotNull((Object)event, (Object)"event cannot be null");
        if (null == this.service) {
            throw new TestEventClientException("Unable to send notification, Orchestrator callback is null");
        }
        try {
            ((OrchestratorCallback)this.service).sendTestNotification(BundleConverter.getBundleFromTestRunEvent(event));
        }
        catch (RemoteException e) {
            String string = String.valueOf(event.getClass());
            throw new TestEventClientException(new StringBuilder(32 + String.valueOf(string).length()).append("Unable to send test run event [").append(string).append("]").toString(), e);
        }
    }
}

