/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.internal.deps.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.test.runner.internal.deps.aidl.TransactionInterceptor;

public abstract class BaseStub
extends Binder
implements IInterface {
    private static TransactionInterceptor globalInterceptor = null;

    public IBinder asBinder() {
        return this;
    }

    protected BaseStub(String descriptor) {
        this.attachInterface(this, descriptor);
    }

    static synchronized void installTransactionInterceptorPackagePrivate(TransactionInterceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("null interceptor");
        }
        if (globalInterceptor != null) {
            throw new IllegalStateException("Duplicate TransactionInterceptor installation.");
        }
        globalInterceptor = interceptor;
    }

    protected boolean dispatchTransaction(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        return false;
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (this.routeToSuperOrEnforceInterface(code, data, reply, flags)) {
            return true;
        }
        if (globalInterceptor == null) {
            return this.dispatchTransaction(code, data, reply, flags);
        }
        return globalInterceptor.interceptTransaction(this, code, data, reply, flags);
    }

    protected boolean routeToSuperOrEnforceInterface(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code > 0xFFFFFF) {
            return super.onTransact(code, data, reply, flags);
        }
        data.enforceInterface(this.getInterfaceDescriptor());
        return false;
    }
}

