/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.internal;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.services.events.internal.Throwables;
import org.junit.runner.notification.Failure;

public final class StackTrimmer {
    private static final String TAG = "StackTrimmer";
    @VisibleForTesting
    static final int MAX_TRACE_SIZE = 65536;

    public static String getTrimmedMessage(Failure failure) {
        String message = failure.getMessage();
        if (message != null && message.length() > 65536) {
            Log.w((String)TAG, (String)String.format("Message too long, trimmed to first %s characters.", 65536));
            message = String.valueOf(message.substring(0, 65536)).concat("\n");
        }
        return message;
    }

    public static String getTrimmedStackTrace(Failure failure) {
        String trace = Throwables.getTrimmedStackTrace(failure.getException());
        if (trace.length() > 65536) {
            Log.w((String)TAG, (String)String.format("Stack trace too long, trimmed to first %s characters.", 65536));
            trace = String.valueOf(trace.substring(0, 65536)).concat("\n");
        }
        return trace;
    }

    private StackTrimmer() {
    }
}

