/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.run;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.test.services.events.run.TestAssumptionFailureEvent;
import androidx.test.services.events.run.TestFailureEvent;
import androidx.test.services.events.run.TestFinishedEvent;
import androidx.test.services.events.run.TestIgnoredEvent;
import androidx.test.services.events.run.TestRunEvent;
import androidx.test.services.events.run.TestRunFinishedEvent;
import androidx.test.services.events.run.TestRunStartedEvent;
import androidx.test.services.events.run.TestStartedEvent;

final class TestRunEventFactory
implements Parcelable.Creator<TestRunEvent> {
    public TestRunEvent createFromParcel(Parcel source) {
        TestRunEvent.EventType instanceType = TestRunEvent.EventType.valueOf(source.readString());
        switch (instanceType) {
            case STARTED: {
                return new TestRunStartedEvent(source);
            }
            case TEST_STARTED: {
                return new TestStartedEvent(source);
            }
            case TEST_FINISHED: {
                return new TestFinishedEvent(source);
            }
            case TEST_ASSUMPTION_FAILURE: {
                return new TestAssumptionFailureEvent(source);
            }
            case TEST_FAILURE: {
                return new TestFailureEvent(source);
            }
            case TEST_IGNORED: {
                return new TestIgnoredEvent(source);
            }
            case FINISHED: {
                return new TestRunFinishedEvent(source);
            }
        }
        String string = String.valueOf((Object)instanceType);
        throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(string).length()).append("Unhandled event type: ").append(string).toString());
    }

    TestRunEventFactory() {
    }

    public TestRunEvent[] newArray(int size) {
        return new TestRunEvent[size];
    }
}

