/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.callback;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.test.internal.events.client.TestEventClientException;
import androidx.test.orchestrator.junit.ParcelableDescription;
import androidx.test.orchestrator.junit.ParcelableFailure;
import androidx.test.orchestrator.junit.ParcelableResult;
import androidx.test.orchestrator.listeners.OrchestrationListenerManager;
import androidx.test.services.events.FailureInfo;
import androidx.test.services.events.run.TestAssumptionFailureEvent;
import androidx.test.services.events.run.TestFailureEvent;
import androidx.test.services.events.run.TestFinishedEvent;
import androidx.test.services.events.run.TestIgnoredEvent;
import androidx.test.services.events.run.TestRunEvent;
import androidx.test.services.events.run.TestRunEventWithTestCase;
import androidx.test.services.events.run.TestRunFinishedEvent;
import androidx.test.services.events.run.TestRunStartedEvent;
import androidx.test.services.events.run.TestStartedEvent;
import java.util.ArrayList;
import java.util.List;

class BundleConverter {
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_FAILURE = "failure";
    private static final String KEY_RESULT = "result";

    @NonNull
    private static Bundle getBundleFromFailureEvent(@NonNull TestFailureEvent event, @NonNull OrchestrationListenerManager.TestEvent testFailureEventType) {
        Bundle bundle = new Bundle();
        ParcelableDescription description = new ParcelableDescription(event.testCase.getClassAndMethodName());
        ParcelableFailure failure = new ParcelableFailure(description, event.failure.stackTrace);
        bundle.putParcelable(KEY_FAILURE, (Parcelable)failure);
        bundle.putString("TestEvent", testFailureEventType.name());
        return bundle;
    }

    @NonNull
    private static Bundle getBundleFromTestCaseEvent(@NonNull TestRunEventWithTestCase event, @NonNull OrchestrationListenerManager.TestEvent testEventType) {
        Bundle bundle = new Bundle();
        ParcelableDescription description = new ParcelableDescription(event.testCase.getClassAndMethodName());
        bundle.putParcelable(KEY_DESCRIPTION, (Parcelable)description);
        bundle.putString("TestEvent", testEventType.name());
        return bundle;
    }

    @NonNull
    public static Bundle getBundleFromTestRunEvent(@NonNull TestRunEvent event) throws TestEventClientException {
        if (event instanceof TestAssumptionFailureEvent) {
            return BundleConverter.getBundleFromFailureEvent((TestAssumptionFailureEvent)event, OrchestrationListenerManager.TestEvent.TEST_ASSUMPTION_FAILURE);
        }
        if (event instanceof TestFailureEvent) {
            return BundleConverter.getBundleFromFailureEvent((TestFailureEvent)event, OrchestrationListenerManager.TestEvent.TEST_FAILURE);
        }
        if (event instanceof TestFinishedEvent) {
            return BundleConverter.getBundleFromTestCaseEvent((TestFinishedEvent)event, OrchestrationListenerManager.TestEvent.TEST_FINISHED);
        }
        if (event instanceof TestIgnoredEvent) {
            return BundleConverter.getBundleFromTestCaseEvent((TestIgnoredEvent)event, OrchestrationListenerManager.TestEvent.TEST_IGNORED);
        }
        if (event instanceof TestRunFinishedEvent) {
            return BundleConverter.getBundleFromTestRunFinishedEvent((TestRunFinishedEvent)event);
        }
        if (event instanceof TestRunStartedEvent) {
            return BundleConverter.getBundleFromTestCaseEvent((TestRunStartedEvent)event, OrchestrationListenerManager.TestEvent.TEST_RUN_STARTED);
        }
        if (event instanceof TestStartedEvent) {
            return BundleConverter.getBundleFromTestCaseEvent((TestStartedEvent)event, OrchestrationListenerManager.TestEvent.TEST_STARTED);
        }
        String string = String.valueOf(event);
        throw new TestEventClientException("Unrecognized test run event type [" + string + "]");
    }

    @NonNull
    private static Bundle getBundleFromTestRunFinishedEvent(@NonNull TestRunFinishedEvent event) {
        Bundle bundle = new Bundle();
        ParcelableResult result = new ParcelableResult(BundleConverter.getParcelableFailureFromList(event.failures));
        bundle.putParcelable(KEY_RESULT, (Parcelable)result);
        bundle.putString("TestEvent", OrchestrationListenerManager.TestEvent.TEST_RUN_FINISHED.name());
        return bundle;
    }

    @NonNull
    private static List<ParcelableFailure> getParcelableFailureFromList(@NonNull List<FailureInfo> failures) {
        ArrayList<ParcelableFailure> result = new ArrayList<ParcelableFailure>();
        for (FailureInfo failure : failures) {
            ParcelableDescription description = new ParcelableDescription(failure.testCase.getClassAndMethodName());
            ParcelableFailure parcelable = new ParcelableFailure(description, failure.stackTrace);
            result.add(parcelable);
        }
        return result;
    }

    private BundleConverter() {
    }
}

