/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.internal.deps.aidl;

import android.os.BadParcelableException;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Codecs {
    private static final ClassLoader CLASS_LOADER = Codecs.class.getClassLoader();

    public static <T extends Parcelable> T createParcelable(Parcel parcel, Parcelable.Creator<T> creator) {
        if (parcel.readInt() == 0) {
            return null;
        }
        return (T)((Parcelable)creator.createFromParcel(parcel));
    }

    public static CharSequence createCharSequence(Parcel parcel) {
        if (parcel.readInt() == 0) {
            return null;
        }
        return (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
    }

    public static ArrayList createList(Parcel parcel) {
        return parcel.readArrayList(CLASS_LOADER);
    }

    public static HashMap createMap(Parcel parcel) {
        return parcel.readHashMap(CLASS_LOADER);
    }

    private Codecs() {
    }

    public static void enforceNoDataAvail(Parcel parcel) {
        int n = parcel.dataAvail();
        if (n > 0) {
            throw new BadParcelableException(new StringBuilder(56).append("Parcel data not fully consumed, unread size: ").append(n).toString());
        }
    }

    public static void readList(Parcel parcel, List<?> list) {
        parcel.readList(list, CLASS_LOADER);
    }

    public static void readMap(Parcel parcel, Map<?, ?> map) {
        parcel.readMap(map, CLASS_LOADER);
    }

    public static void writeBoolean(Parcel parcel, boolean value) {
        parcel.writeInt(value ? 1 : 0);
    }

    public static void writeCharSequence(Parcel parcel, CharSequence charSequence) {
        if (charSequence != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel((CharSequence)charSequence, (Parcel)parcel, (int)0);
        } else {
            parcel.writeInt(0);
        }
    }

    public static void writeCharSequenceAsReturnValue(Parcel parcel, CharSequence charSequence) {
        if (charSequence != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel((CharSequence)charSequence, (Parcel)parcel, (int)1);
        } else {
            parcel.writeInt(0);
        }
    }

    public static void writeParcelable(Parcel parcel, Parcelable parcelable) {
        if (parcelable == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(1);
            parcelable.writeToParcel(parcel, 0);
        }
    }

    public static void writeParcelableAsReturnValue(Parcel parcel, Parcelable parcelable) {
        if (parcelable == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(1);
            parcelable.writeToParcel(parcel, 1);
        }
    }

    public static void writeStrongBinder(Parcel parcel, IInterface iinterface) {
        if (iinterface == null) {
            parcel.writeStrongBinder(null);
        } else {
            parcel.writeStrongBinder(iinterface.asBinder());
        }
    }

    public static boolean createBoolean(Parcel parcel) {
        return parcel.readInt() != 0;
    }
}

