/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.util.Log;
import androidx.test.internal.runner.ErrorReportingRunner;
import androidx.test.internal.runner.TestLoader;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

class DirectTestLoader
extends TestLoader {
    private static final String LOG_TAG = "DirectTestLoader";
    private final ClassLoader classLoader;
    private final RunnerBuilder runnerBuilder;

    @Override
    protected Runner doCreateRunner(String className) {
        try {
            Class<?> loadedClass = Class.forName(className, false, this.classLoader);
            return this.runnerBuilder.safeRunnerForClass(loadedClass);
        }
        catch (ClassNotFoundException | LinkageError e) {
            String msg = String.format("Failed loading specified test class '%s'", className);
            Log.e((String)LOG_TAG, (String)msg, (Throwable)e);
            return new ErrorReportingRunner(className, new RuntimeException(msg, e));
        }
    }

    DirectTestLoader(ClassLoader classLoader, RunnerBuilder runnerBuilder) {
        this.classLoader = classLoader;
        this.runnerBuilder = runnerBuilder;
    }
}

