/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import androidx.test.internal.runner.junit3.AndroidJUnit3Builder;
import androidx.test.internal.runner.junit3.AndroidSuiteBuilder;
import androidx.test.internal.runner.junit4.AndroidAnnotatedBuilder;
import androidx.test.internal.runner.junit4.AndroidJUnit4Builder;
import androidx.test.internal.util.AndroidRunnerParams;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.internal.builders.IgnoredBuilder;
import org.junit.internal.builders.JUnit3Builder;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

class AndroidRunnerBuilder
extends AllDefaultPossibilitiesBuilder {
    private final AndroidJUnit3Builder androidJUnit3Builder;
    private final AndroidJUnit4Builder androidJUnit4Builder;
    private final AndroidSuiteBuilder androidSuiteBuilder;
    private final AndroidAnnotatedBuilder androidAnnotatedBuilder;
    private final IgnoredBuilder ignoredBuilder;
    private final List<RunnerBuilder> customRunnerBuilders;

    public AndroidRunnerBuilder(AndroidRunnerParams runnerParams) {
        this(null, runnerParams, Collections.emptyList());
    }

    AndroidRunnerBuilder(AndroidRunnerParams runnerParams, List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        this(null, runnerParams, customRunnerBuilderClasses);
    }

    AndroidRunnerBuilder(RunnerBuilder suiteBuilder, AndroidRunnerParams runnerParams, List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        super(true);
        this.androidJUnit3Builder = new AndroidJUnit3Builder(runnerParams);
        this.androidJUnit4Builder = new AndroidJUnit4Builder(runnerParams);
        this.androidSuiteBuilder = new AndroidSuiteBuilder(runnerParams);
        this.androidAnnotatedBuilder = new AndroidAnnotatedBuilder((RunnerBuilder)(suiteBuilder == null ? this : suiteBuilder), runnerParams);
        this.ignoredBuilder = new IgnoredBuilder();
        this.customRunnerBuilders = this.instantiateRunnerBuilders(customRunnerBuilderClasses);
    }

    private List<RunnerBuilder> instantiateRunnerBuilders(List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        ArrayList<RunnerBuilder> runnerBuilders = new ArrayList<RunnerBuilder>();
        for (Class<? extends RunnerBuilder> customRunnerBuilderClass : customRunnerBuilderClasses) {
            try {
                RunnerBuilder runnerBuilder = customRunnerBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                runnerBuilders.add(runnerBuilder);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Could not create instance of " + customRunnerBuilderClass + ", make sure that it is a public concrete class with a public no-argument constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not create instance of " + customRunnerBuilderClass + ", make sure that it is a public concrete class with a public no-argument constructor", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not create instance of " + customRunnerBuilderClass + ", make sure that it is a public concrete class with a public no-argument constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Could not create instance of " + customRunnerBuilderClass + ", the constructor must not throw an exception", e);
            }
        }
        return runnerBuilders;
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        for (RunnerBuilder customRunnerBuilder : this.customRunnerBuilders) {
            Runner runner = customRunnerBuilder.safeRunnerForClass(testClass);
            if (runner == null) continue;
            return runner;
        }
        return super.runnerForClass(testClass);
    }

    protected JUnit4Builder junit4Builder() {
        return this.androidJUnit4Builder;
    }

    protected JUnit3Builder junit3Builder() {
        return this.androidJUnit3Builder;
    }

    protected AnnotatedBuilder annotatedBuilder() {
        return this.androidAnnotatedBuilder;
    }

    protected IgnoredBuilder ignoredBuilder() {
        return this.ignoredBuilder;
    }

    protected RunnerBuilder suiteMethodBuilder() {
        return this.androidSuiteBuilder;
    }
}

