/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit3;

import android.util.Log;
import androidx.test.internal.runner.EmptyTestRunner;
import androidx.test.internal.runner.junit3.AndroidTestSuite;
import androidx.test.internal.runner.junit3.JUnit38ClassRunner;
import androidx.test.internal.util.AndroidRunnerBuilderUtil;
import androidx.test.internal.util.AndroidRunnerParams;
import junit.framework.Test;
import org.junit.internal.builders.JUnit3Builder;
import org.junit.runner.Runner;

public class AndroidJUnit3Builder
extends JUnit3Builder {
    private static final String TAG = "AndroidJUnit3Builder";
    private final AndroidRunnerParams androidRunnerParams;

    public AndroidJUnit3Builder(AndroidRunnerParams runnerParams) {
        this.androidRunnerParams = runnerParams;
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        try {
            if (AndroidRunnerBuilderUtil.isJUnit3Test(testClass)) {
                if (!AndroidRunnerBuilderUtil.hasJUnit3TestMethod(testClass)) {
                    return new EmptyTestRunner(testClass);
                }
                return new JUnit38ClassRunner((Test)new AndroidTestSuite(testClass, this.androidRunnerParams));
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Error constructing runner", (Throwable)e);
            throw e;
        }
        return null;
    }
}

