/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.test.internal.util.Checks;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

public final class TimeStamp
implements Parcelable {
    @NonNull
    public final Long seconds;
    @NonNull
    public final Integer nanos;
    static Clock clock = null;
    public static final Parcelable.Creator<TimeStamp> CREATOR = new Parcelable.Creator<TimeStamp>(){

        public TimeStamp createFromParcel(Parcel source) {
            return new TimeStamp(source);
        }

        public TimeStamp[] newArray(int size) {
            return new TimeStamp[size];
        }
    };

    public TimeStamp(@NonNull Long seconds, @NonNull Integer nanos) {
        this.seconds = (Long)Checks.checkNotNull((Object)seconds, (Object)"seconds cannot be null");
        this.nanos = (Integer)Checks.checkNotNull((Object)nanos, (Object)"nanos cannot be null");
    }

    public TimeStamp(@NonNull Parcel source) {
        Checks.checkNotNull((Object)source, (Object)"source cannot be null");
        this.seconds = (Long)Checks.checkNotNull((Object)source.readLong(), (Object)"seconds cannot be null");
        this.nanos = (Integer)Checks.checkNotNull((Object)source.readInt(), (Object)"nanos cannot be null");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeLong(this.seconds.longValue());
        parcel.writeInt(this.nanos.intValue());
    }

    @TargetApi(value=26)
    private static TimeStamp modernNow() {
        if (clock == null) {
            clock = Clock.systemUTC();
        }
        Instant now = Instant.now(clock);
        return new TimeStamp(now.getEpochSecond(), now.getNano());
    }

    @TargetApi(value=25)
    private static TimeStamp legacyNow() {
        long now = System.currentTimeMillis();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(now);
        long nanosOffset = TimeUnit.MILLISECONDS.toNanos(now) - TimeUnit.SECONDS.toNanos(seconds);
        return new TimeStamp(seconds, (int)nanosOffset);
    }

    public static TimeStamp now() {
        if (Build.VERSION.SDK_INT >= 26) {
            return TimeStamp.modernNow();
        }
        return TimeStamp.legacyNow();
    }
}

