/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.internal.events.client.JUnitValidator;
import androidx.test.internal.events.client.TestRunEventService;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.FailureInfo;
import androidx.test.services.events.ParcelableConverter;
import androidx.test.services.events.TestCaseInfo;
import androidx.test.services.events.TestEventException;
import androidx.test.services.events.run.TestAssumptionFailureEvent;
import androidx.test.services.events.run.TestFailureEvent;
import androidx.test.services.events.run.TestFinishedEvent;
import androidx.test.services.events.run.TestIgnoredEvent;
import androidx.test.services.events.run.TestRunFinishedEvent;
import androidx.test.services.events.run.TestRunStartedEvent;
import androidx.test.services.events.run.TestStartedEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class OrchestratedInstrumentationListener
extends RunListener {
    private static final String TAG = "OrchestrationListener";
    private final TestRunEventService notificationService;
    private final AtomicBoolean isTestFailed = new AtomicBoolean(false);
    private Description description = Description.EMPTY;

    public OrchestratedInstrumentationListener(@NonNull TestRunEventService notificationService) {
        Checks.checkNotNull((Object)notificationService, (Object)"notificationService cannot be null");
        this.notificationService = notificationService;
    }

    public void testRunStarted(Description description) {
        try {
            this.notificationService.send(new TestRunStartedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunStartedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testRunFinished(Result result) {
        List<FailureInfo> failures = Collections.emptyList();
        try {
            failures = ParcelableConverter.getFailuresFromList(result.getFailures());
        }
        catch (TestEventException e) {
            Log.w((String)TAG, (String)"Failure event doesn't contain a test case", (Throwable)e);
        }
        try {
            this.notificationService.send(new TestRunFinishedEvent(result.getRunCount(), result.getIgnoreCount(), result.getRunTime(), failures));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunFinishedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testStarted(Description description) {
        this.description = description;
        if (!JUnitValidator.validateDescription(description)) {
            Log.w((String)TAG, (String)("testStarted: JUnit reported " + description.getClassName() + "#" + description.getMethodName() + "; discarding as bogus."));
            return;
        }
        try {
            this.notificationService.send(new TestStartedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestStartedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testFinished(Description description) {
        if (!JUnitValidator.validateDescription(description)) {
            Log.w((String)TAG, (String)("testFinished: JUnit reported " + description.getClassName() + "#" + description.getMethodName() + "; discarding as bogus."));
            return;
        }
        try {
            this.notificationService.send(new TestFinishedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestFinishedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testFailure(Failure failure) {
        if (this.isTestFailed.compareAndSet(false, true)) {
            TestFailureEvent event;
            block6: {
                Description description = failure.getDescription();
                if (!JUnitValidator.validateDescription(description)) {
                    Log.w((String)TAG, (String)("testFailure: JUnit reported " + description.getClassName() + "#" + description.getMethodName() + "; discarding as bogus."));
                    return;
                }
                try {
                    event = new TestFailureEvent(ParcelableConverter.getTestCaseFromDescription(failure.getDescription()), ParcelableConverter.getFailure(failure));
                }
                catch (TestEventException e) {
                    Log.d((String)TAG, (String)("Unable to determine test case from failure [" + failure + "]"), (Throwable)e);
                    event = this.getTestFailureEventFromCachedDescription(failure);
                    if (event != null) break block6;
                    return;
                }
            }
            try {
                this.notificationService.send(event);
            }
            catch (TestEventException e) {
                throw new IllegalStateException("Unable to send TestFailureEvent, terminating", e);
            }
        }
    }

    @Nullable
    private TestFailureEvent getTestFailureEventFromCachedDescription(@NonNull Failure failure) {
        TestCaseInfo testCase;
        Checks.checkNotNull((Object)failure, (Object)"failure cannot be null");
        try {
            testCase = ParcelableConverter.getTestCaseFromDescription(this.description);
        }
        catch (TestEventException ex) {
            Log.e((String)TAG, (String)("Unable to determine test case from description [" + this.description + "]"), (Throwable)ex);
            return null;
        }
        return new TestFailureEvent(testCase, new FailureInfo(failure.getMessage(), failure.getTestHeader(), failure.getTrace(), testCase));
    }

    public void testAssumptionFailure(Failure failure) {
        try {
            this.notificationService.send(new TestAssumptionFailureEvent(ParcelableConverter.getTestCaseFromDescription(failure.getDescription()), ParcelableConverter.getFailure(failure)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestAssumptionFailureEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testIgnored(Description description) {
        try {
            TestCaseInfo info = ParcelableConverter.getTestCaseFromDescription(description);
            Log.i((String)TAG, (String)("TestIgnoredEvent(" + description.getDisplayName() + "): " + description.getClassName() + "#" + description.getMethodName() + " = " + info.getClassAndMethodName()));
            this.notificationService.send(new TestIgnoredEvent(info));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestIgnoredEvent to Orchestrator", (Throwable)e);
        }
    }

    public boolean reportProcessCrash(Throwable t, long timeoutMillis) {
        if (!this.isTestFailed.get()) {
            Log.i((String)TAG, (String)"No test failure has been reported. Report the process crash.");
            this.reportProcessCrash(t);
            return true;
        }
        return false;
    }

    private void reportProcessCrash(Throwable t) {
        this.testFailure(new Failure(this.description, t));
        this.testFinished(this.description);
    }
}

