/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.filters;

import androidx.test.filters.AbstractFilter;
import java.util.regex.Pattern;
import org.junit.runner.Description;

public final class TestsRegExFilter
extends AbstractFilter {
    private Pattern pattern = null;

    public void setPattern(String patternString) {
        this.pattern = Pattern.compile(patternString);
    }

    @Override
    protected boolean evaluateTest(Description description) {
        if (this.pattern == null) {
            return true;
        }
        String testName = String.format("%s#%s", description.getClassName(), description.getMethodName());
        return this.pattern.matcher(testName).find();
    }

    public String describe() {
        return "tests filter";
    }
}

