/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.TestSize;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class SuiteAssignmentPrinter
extends InstrumentationRunListener {
    @VisibleForTesting
    long startTime;
    @VisibleForTesting
    long endTime;
    @VisibleForTesting
    boolean timingValid;

    public void testStarted(Description description) throws Exception {
        this.timingValid = true;
        this.startTime = this.getCurrentTimeMillis();
    }

    public void testFinished(Description description) throws Exception {
        this.endTime = this.getCurrentTimeMillis();
        if (!this.timingValid || this.startTime < 0L) {
            this.sendString("F");
            Log.d((String)"SuiteAssignmentPrinter", (String)String.format("%s#%s: skipping suite assignment due to test failure\n", description.getClassName(), description.getMethodName()));
        } else {
            TestSize currentRenameSize;
            long runTime = this.endTime - this.startTime;
            TestSize assignmentSuite = TestSize.getTestSizeForRunTime(runTime);
            if (!assignmentSuite.equals(currentRenameSize = TestSize.fromDescription(description))) {
                this.sendString(String.format("\n%s#%s: current size: %s. suggested: %s runTime: %d ms\n", description.getClassName(), description.getMethodName(), currentRenameSize, assignmentSuite.getSizeQualifierName(), runTime));
            } else {
                this.sendString(".");
                Log.d((String)"SuiteAssignmentPrinter", (String)String.format("%s#%s assigned correctly as %s. runTime: %d ms\n", description.getClassName(), description.getMethodName(), assignmentSuite.getSizeQualifierName(), runTime));
            }
        }
        this.startTime = -1L;
    }

    public void testFailure(Failure failure) throws Exception {
        this.timingValid = false;
    }

    public void testAssumptionFailure(Failure failure) {
        this.timingValid = false;
    }

    public void testIgnored(Description description) throws Exception {
        this.timingValid = false;
    }

    @VisibleForTesting
    public long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

